/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.factplusplusad;

import java.util.Collection;
import java.util.stream.Stream;
import org.semanticweb.owlapi.atomicdecomposition.ModuleMethod;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import org.semanticweb.owlapitools.decomposition.AxiomWrapper;
import uk.ac.manchester.cs.factplusplusad.Modularizer;
import uk.ac.manchester.cs.factplusplusad.Signature;
import uk.ac.manchester.cs.owlapi.modularity.ModuleType;

public class OntologyBasedModularizer {
    OWLOntology ontology;
    Modularizer modularizer;

    public OntologyBasedModularizer(OWLOntology ontology, ModuleMethod moduleMethod) {
        this.ontology = ontology;
        this.modularizer = new Modularizer(moduleMethod);
        this.modularizer.preprocessOntology(OWLAPIStreamUtils.asList(ontology.axioms().map(a -> new AxiomWrapper((OWLAxiom)a))));
    }

    Collection<AxiomWrapper> getModule(Collection<AxiomWrapper> from, Signature sig, ModuleType type) {
        this.modularizer.extract(from, sig, type);
        return this.modularizer.getModule();
    }

    Collection<AxiomWrapper> getModule(Signature sig, ModuleType type) {
        return this.getModule(OWLAPIStreamUtils.asList(this.ontology.axioms().map(a -> new AxiomWrapper((OWLAxiom)a))), sig, type);
    }

    Modularizer getModularizer() {
        return this.modularizer;
    }

    public Collection<OWLAxiom> getModule(Stream<OWLEntity> entities, ModuleType type) {
        return OWLAPIStreamUtils.asList(this.getModule(new Signature(entities), type).stream().map(AxiomWrapper::getAxiom).filter(a -> a != null));
    }
}

