/*
 * Decompiled with CFR 0.152.
 */
package de.jpdigital.owl.apigenerator.core;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.commons.text.WordUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.semanticweb.owlapi.model.IRI;

public class Utils {
    private static final Logger LOGGER = LogManager.getLogger(Utils.class);

    private Utils() {
    }

    public static String generatePackageName(IRI fromIri) {
        return Utils.generatePackageName(fromIri, true);
    }

    public static String generatePackageName(IRI fromIri, boolean lowerCase) {
        LOGGER.info("Generating package name from IRI {}...", (Object)fromIri.toString());
        String scheme = fromIri.getScheme();
        String namespace = scheme == null || scheme.isEmpty() ? fromIri.getNamespace() : fromIri.getNamespace().substring(scheme.length() + 3);
        int domainIndexEnd = namespace.indexOf(47);
        String domain = namespace.substring(0, domainIndexEnd);
        String path = namespace.endsWith("#") ? namespace.substring(domainIndexEnd + 1, namespace.length() - 1) : namespace.substring(domainIndexEnd + 1);
        ArrayList<String> tokens = new ArrayList<String>(Arrays.asList(domain.split("\\.")));
        Collections.reverse(tokens);
        tokens.addAll(Arrays.stream(path.split("/")).map(token -> token.replace('.', '-')).collect(Collectors.toList()));
        String packageName = tokens.stream().filter(token -> !token.isEmpty()).map(token -> WordUtils.capitalize((String)token, (char[])new char[]{'-'})).map(token -> WordUtils.uncapitalize((String)token)).map(token -> token.replace("-", "")).map(token -> token.replace('.', '_')).map(token -> Utils.avoidNumericBegin(token)).collect(Collectors.joining("."));
        LOGGER.info("Generated package name '{}' from IRI '{}'.", (Object)packageName, (Object)fromIri.toString());
        if (lowerCase) {
            return packageName.toLowerCase(Locale.ROOT);
        }
        return packageName;
    }

    public static Path generatePackagePath(String packageName) {
        return Paths.get(packageName.replace('.', '/'), new String[0]);
    }

    private static String avoidNumericBegin(String value) {
        if (value.matches("^[0-9].*")) {
            return String.format("_%s", value);
        }
        return value;
    }
}

