/*
 * Decompiled with CFR 0.152.
 */
package de.jpdigital.owl.apigenerator.core;

import de.jpdigital.owl.apigenerator.core.IriBundle;
import de.jpdigital.owl.apigenerator.core.IriConstantsGenerationFailedExpection;
import de.jpdigital.owl.apigenerator.core.OwlEntityType;
import de.jpdigital.owl.apigenerator.core.Utils;
import java.nio.file.Path;
import org.apache.commons.text.WordUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.semanticweb.owlapi.model.IRI;

class IriBundleBuilder {
    private static final Logger LOGGER = LogManager.getLogger(IriBundleBuilder.class);
    private final IRI iri;
    private final OwlEntityType owlEntityType;

    IriBundleBuilder(IRI iri, OwlEntityType owlEntityType) {
        this.iri = iri;
        this.owlEntityType = owlEntityType;
    }

    IriBundle build() throws IriConstantsGenerationFailedExpection {
        LOGGER.debug("Building IriBundle for IRI \"{}\" and entity type \"{}\":", (Object)this.iri.toString(), (Object)this.owlEntityType.toString());
        String namespace = this.iri.getNamespace();
        String packageName = Utils.generatePackageName(this.iri);
        Path packagePath = Utils.generatePackagePath(packageName);
        String className = this.generateClassName(Utils.generatePackageName(this.iri, false));
        LOGGER.debug("\t namespace: {}", (Object)namespace);
        LOGGER.debug("\t packageName: {}", (Object)packageName);
        LOGGER.debug("\t packagePath: {}", (Object)packagePath.toString());
        LOGGER.debug("\t className: {}", (Object)className);
        return new IriBundle(namespace, packageName, packagePath, className);
    }

    private String generateClassName(String packageName) throws IriConstantsGenerationFailedExpection {
        String suffix;
        switch (this.owlEntityType) {
            case ANNOTATION_VALUE: {
                suffix = "AnnotationValues";
                break;
            }
            case ANNOTIATION_PROPERTY: {
                suffix = "AnnotationProperties";
                break;
            }
            case CLASS: {
                suffix = "OwlClasses";
                break;
            }
            case DATA_PROPERTY: {
                suffix = "DataProperties";
                break;
            }
            case INDIVIDUAL: {
                suffix = "Individuals";
                break;
            }
            case OBJECT_PROPERTY: {
                suffix = "ObjectProperties";
                break;
            }
            default: {
                throw new IriConstantsGenerationFailedExpection(String.format("Unknown entityType \"%s\".", new Object[]{this.owlEntityType}));
            }
        }
        int lastDotIndex = packageName.lastIndexOf(46);
        String className = WordUtils.capitalize((String)String.format("%s%s", packageName.substring(lastDotIndex + 1), suffix), (char[])new char[]{'-', '.'}).replace("-", "");
        return this.avoidNumericBegin(className);
    }

    private String avoidNumericBegin(String value) {
        if (value.matches("^[0-9].*")) {
            return String.format("_%s", value);
        }
        return value;
    }
}

