/*
 * Decompiled with CFR 0.152.
 */
package de.jpdigital.owl.apigenerator.core;

import de.jpdigital.owl.apigenerator.core.OntologyOwlApi;
import de.jpdigital.owl.apigenerator.core.RepositoryGenerationFailedException;
import de.jpdigital.owl.apigenerator.core.TemplateService;
import de.jpdigital.owl.apigenerator.core.Utils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.text.WordUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.parameters.Imports;

public class RepositoryGenerator {
    private static final Logger LOGGER = LogManager.getLogger(RepositoryGenerator.class);
    private final OntologyOwlApi ontologyOwlApi;
    private final Path outputDir;

    private RepositoryGenerator(OntologyOwlApi ontologyOwlApi, Path outputDir) {
        this.ontologyOwlApi = ontologyOwlApi;
        this.outputDir = outputDir;
    }

    public static RepositoryGenerator buildRepositoryGenerator(OntologyOwlApi ontologyOwlApi, Path outputDir) {
        if (!Files.isDirectory(outputDir, new LinkOption[0])) {
            throw new IllegalArgumentException(String.format("The provided path \"%s\" is not a directory.", outputDir.toString()));
        }
        if (!Files.isWritable(outputDir)) {
            throw new IllegalArgumentException(String.format("The provided output directory \"%s\" is not writable.", outputDir.toString()));
        }
        Objects.requireNonNull(ontologyOwlApi, "ontologyOwlApi can't be null");
        return new RepositoryGenerator(ontologyOwlApi, outputDir);
    }

    public void generateRepositoryClasses() throws RepositoryGenerationFailedException {
        Set owlClasses = this.ontologyOwlApi.getOntology().classesInSignature(Imports.INCLUDED).filter(owlClass -> !owlClass.getIRI().toString().startsWith("http://www.w3.org/")).collect(Collectors.toSet());
        for (OWLClass owlClass2 : owlClasses) {
            this.generateRepositoryClass(owlClass2);
        }
    }

    private void generateRepositoryClass(OWLClass owlClass) throws RepositoryGenerationFailedException {
        LOGGER.info("OWL class {} is in the domain of the following data properties:", (Object)owlClass.getIRI().toString());
        List<IRI> dataPropertesIris = this.ontologyOwlApi.getOntology().dataPropertiesInSignature(Imports.INCLUDED).filter(dataProp -> this.classInDomainOfDataProperty(owlClass, (OWLDataProperty)dataProp)).map(dataProp -> dataProp.getIRI()).collect(Collectors.toList());
        dataPropertesIris.forEach(dataProp -> LOGGER.info("* {}", (Object)dataProp.toString()));
        List dataProperties = dataPropertesIris.stream().map(dataProperty -> dataProperty.getShortForm()).collect(Collectors.toList());
        String packageName = Utils.generatePackageName(owlClass.getIRI());
        String className = this.generateClassName(owlClass.getIRI());
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        dataModel.put("license", "");
        dataModel.put("package", packageName);
        dataModel.put("classIri", owlClass.getIRI().toString());
        dataModel.put("className", className);
        dataModel.put("owlClassName", owlClass.getIRI().getShortForm());
        dataModel.put("dataProperties", dataProperties);
        Path packagePath = Utils.generatePackagePath(packageName);
        TemplateService templateService = TemplateService.getTemplateService();
        String result = templateService.processTemplate("Repository.java.ftl", dataModel);
        Path packageDir = this.outputDir.resolve(packagePath);
        Path classFile = packageDir.resolve(String.format("%s.java", className));
        try {
            Files.createDirectories(packageDir, new FileAttribute[0]);
            Files.write(classFile, result.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException ex) {
            throw new RepositoryGenerationFailedException(ex);
        }
    }

    private boolean classInDomainOfDataProperty(OWLClass owlClass, OWLDataProperty dataProperty) {
        return this.ontologyOwlApi.getReasoner().dataPropertyDomains(dataProperty).anyMatch(classInDomain -> classInDomain.equals(owlClass));
    }

    private String generateClassName(IRI iri) {
        String iriShortForm = iri.getShortForm();
        String capitalized = WordUtils.capitalize((String)iriShortForm, (char[])new char[]{'-', '_'});
        String replaced = capitalized.replace("-", "").replace('.', '_');
        if (replaced.matches("^[0-9].*")) {
            return String.format("_%s", replaced);
        }
        return replaced;
    }
}

