/*
 * Decompiled with CFR 0.152.
 */
package de.jpdigital.owlapisimplex.maven;

import de.jpdigital.owl.apigenerator.core.IriConstantsGenerationFailedExpection;
import de.jpdigital.owl.apigenerator.core.IriConstantsGenerator;
import de.jpdigital.owl.apigenerator.core.OntologyLoaderGenerationFailedException;
import de.jpdigital.owl.apigenerator.core.OntologyLoaderGenerator;
import de.jpdigital.owl.apigenerator.core.OntologyLoadingException;
import de.jpdigital.owl.apigenerator.core.OntologyOwlApi;
import de.jpdigital.owl.apigenerator.core.RepositoryGenerationFailedException;
import de.jpdigital.owl.apigenerator.core.RepositoryGenerator;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.model.Build;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="gen-api", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, threadSafe=true)
public class OwlApiSimplexMojo
extends AbstractMojo {
    @Parameter(required=false, defaultValue="true")
    private boolean generateIriConstantsForClasses;
    @Parameter(required=false, defaultValue="true")
    private boolean generateIriConstantsForObjectProperties;
    @Parameter(required=false, defaultValue="true")
    private boolean generateIriConstantsForDataProperties;
    @Parameter(required=false, defaultValue="true")
    private boolean generateIriConstantsForIndividuals;
    @Parameter(required=false, defaultValue="true")
    private boolean generateIriConstantsForAnnotationProperties;
    @Parameter(required=false, defaultValue="true")
    private boolean generateRepositories;
    @Parameter(required=false, defaultValue="true")
    private boolean generateOntologyLoader;
    @Parameter(required=true)
    private String[] owlFiles;
    @Parameter(defaultValue="${project.build.directory}/generated-sources", property="outputDir", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="${project}", readonly=true)
    private transient MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        OntologyOwlApi ontologyOwlApi;
        boolean result;
        File outputDir = this.outputDirectory;
        this.getLog().info((CharSequence)String.format("Generating API for ontology files:", new Object[0]));
        Arrays.stream(this.owlFiles).forEach(file -> this.getLog().info((CharSequence)String.format("\t%s", file)));
        if (!outputDir.exists() && !(result = outputDir.mkdirs())) {
            throw new MojoFailureException("Failed to create output directory.");
        }
        Build build = this.project.getBuild();
        List resources = build.getResources();
        ArrayList<Path> owlFilePaths = new ArrayList<Path>();
        for (String owlFile : this.owlFiles) {
            owlFilePaths.add(this.findOntologyPath(owlFile, resources));
        }
        try {
            ontologyOwlApi = OntologyOwlApi.loadOntologies(owlFilePaths);
        }
        catch (OntologyLoadingException ex) {
            throw new MojoFailureException("Failed to load ontology files.", (Throwable)ex);
        }
        IriConstantsGenerator iriConstantsGenerator = IriConstantsGenerator.buildIriConstantsGenerator((OntologyOwlApi)ontologyOwlApi, (Path)outputDir.toPath());
        try {
            if (this.generateIriConstantsForClasses) {
                iriConstantsGenerator.generateClassIriConstants();
            }
            if (this.generateIriConstantsForObjectProperties) {
                iriConstantsGenerator.generateObjectPropertyIriConstants();
            }
            if (this.generateIriConstantsForDataProperties) {
                iriConstantsGenerator.generateDataPropertyIriConstants();
            }
            if (this.generateIriConstantsForIndividuals) {
                iriConstantsGenerator.generateIndividualPropertyIriConstants();
            }
            if (this.generateIriConstantsForAnnotationProperties) {
                iriConstantsGenerator.generateAnnotationIriConstants();
            }
        }
        catch (IriConstantsGenerationFailedExpection ex) {
            throw new MojoFailureException("Error while generating IRI constants: ", (Throwable)ex);
        }
        if (this.generateRepositories) {
            RepositoryGenerator repositoryGenerator = RepositoryGenerator.buildRepositoryGenerator((OntologyOwlApi)ontologyOwlApi, (Path)outputDir.toPath());
            try {
                repositoryGenerator.generateRepositoryClasses();
            }
            catch (RepositoryGenerationFailedException ex) {
                throw new MojoFailureException("Error while generating repositories: ", (Throwable)ex);
            }
        }
        if (this.generateOntologyLoader) {
            List resourcePaths = Arrays.stream(this.owlFiles).map(this::generateResourcePath).collect(Collectors.toList());
            OntologyLoaderGenerator ontologyLoaderGenerator = OntologyLoaderGenerator.buildClassPathOntologyLoaderGenerator((OntologyOwlApi)ontologyOwlApi, (Path)outputDir.toPath(), resourcePaths);
            try {
                ontologyLoaderGenerator.generateOntologyLoader();
            }
            catch (OntologyLoaderGenerationFailedException ex) {
                throw new MojoFailureException("Error while generating OntologyLoader: ", (Throwable)ex);
            }
        }
        this.project.addCompileSourceRoot(outputDir.getAbsolutePath());
    }

    private Path findOntologyPath(String owlFilePath, List<Resource> resources) throws MojoFailureException {
        Path ontologyPath = resources.stream().map(resource -> Paths.get(resource.getDirectory(), new String[0])).map(path -> path.resolve(owlFilePath)).filter(path -> Files.isRegularFile(path, new LinkOption[0])).findAny().orElseThrow(() -> new MojoFailureException(String.format("OWL file %s not found in any of the resource directories.", owlFilePath)));
        if (!Files.isReadable(ontologyPath)) {
            throw new MojoFailureException(String.format("OWL file %s (absolute path: %s) is not readable.", owlFilePath, ontologyPath.toString()));
        }
        return ontologyPath;
    }

    private String generateResourcePath(String source) {
        if (source.startsWith("/")) {
            return source;
        }
        return String.format("/%s", source);
    }
}

