/*
 * Decompiled with CFR 0.152.
 */
package de.jpdigital.owlapisimplex;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.reasoner.OWLReasoner;

public class DataProperties {
    private final OWLOntologyManager ontologyManager;
    private final OWLReasoner reasoner;

    private DataProperties(OWLOntologyManager ontologyManager, OWLReasoner reasoner) {
        this.ontologyManager = ontologyManager;
        this.reasoner = reasoner;
    }

    public static DataProperties buildDataProperties(OWLOntologyManager ontologyManager, OWLReasoner reasoner) {
        Objects.requireNonNull(ontologyManager);
        Objects.requireNonNull(reasoner);
        return new DataProperties(ontologyManager, reasoner);
    }

    public Stream<OWLLiteral> dataPropertyValues(OWLNamedIndividual fromIndividual, IRI propertyIri) {
        OWLDataProperty property = this.ontologyManager.getOWLDataFactory().getOWLDataProperty(propertyIri);
        return this.reasoner.dataPropertyValues(fromIndividual, property);
    }

    public List<OWLLiteral> getDataPropertyValues(OWLNamedIndividual fromIndividual, IRI propertyIri) {
        return this.dataPropertyValues(fromIndividual, propertyIri).collect(Collectors.toList());
    }
}

