/*
 * Decompiled with CFR 0.152.
 */
package de.jpdigital.owlapisimplex;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.expression.OWLEntityChecker;
import org.semanticweb.owlapi.expression.ShortFormEntityChecker;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.util.BidirectionalShortFormProvider;
import org.semanticweb.owlapi.util.BidirectionalShortFormProviderAdapter;
import org.semanticweb.owlapi.util.ShortFormProvider;
import org.semanticweb.owlapi.util.SimpleShortFormProvider;
import org.semanticweb.owlapi.util.mansyntax.ManchesterOWLSyntaxParser;

public class Instances {
    private final OWLOntology ontology;
    private final OWLOntologyManager ontologyManager;
    private final OWLReasoner reasoner;

    private Instances(OWLOntology ontology, OWLOntologyManager ontologyManager, OWLReasoner reasoner) {
        this.ontology = ontology;
        this.ontologyManager = ontologyManager;
        this.reasoner = reasoner;
    }

    public static Instances buildInstances(OWLOntology ontology, OWLOntologyManager ontologyManager, OWLReasoner reasoner) {
        Objects.requireNonNull(ontology);
        Objects.requireNonNull(ontologyManager);
        Objects.requireNonNull(reasoner);
        return new Instances(ontology, ontologyManager, reasoner);
    }

    public Stream<OWLNamedIndividual> instances(String query) {
        SimpleShortFormProvider shortFormProvider = new SimpleShortFormProvider();
        Set importsClosure = this.ontology.importsClosure().collect(Collectors.toSet());
        BidirectionalShortFormProviderAdapter bidiShortformProvider = new BidirectionalShortFormProviderAdapter(this.ontologyManager, importsClosure, (ShortFormProvider)shortFormProvider);
        ManchesterOWLSyntaxParser parser = OWLManager.createManchesterParser();
        parser.setDefaultOntology(this.ontology);
        parser.setOWLEntityChecker((OWLEntityChecker)new ShortFormEntityChecker((BidirectionalShortFormProvider)bidiShortformProvider));
        OWLClassExpression queryExpression = parser.parseClassExpression(query);
        return this.reasoner.getInstances(queryExpression, false).entities().sorted(this::sortResults);
    }

    public List<OWLNamedIndividual> getInstances(String query) {
        return this.instances(query).collect(Collectors.toList());
    }

    public Stream<OWLNamedIndividual> instances(IRI iri) {
        return this.instances(iri.getShortForm());
    }

    public List<OWLNamedIndividual> getInstances(IRI iri) {
        return this.instances(iri).collect(Collectors.toList());
    }

    private int sortResults(OWLNamedIndividual result1, OWLNamedIndividual result2) {
        return result1.getIRI().toString().compareTo(result2.getIRI().toString());
    }
}

