/*
 * Decompiled with CFR 0.152.
 */
package de.jpdigital.owlapisimplex;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.reasoner.OWLReasoner;

public class ObjectProperties {
    private final OWLOntologyManager ontologyManager;
    private final OWLReasoner reasoner;

    private ObjectProperties(OWLOntologyManager ontologyManager, OWLReasoner reasoner) {
        this.ontologyManager = ontologyManager;
        this.reasoner = reasoner;
    }

    public static ObjectProperties buildObjectProperties(OWLOntologyManager ontologyManager, OWLReasoner reasoner) {
        Objects.requireNonNull(ontologyManager);
        Objects.requireNonNull(reasoner);
        return new ObjectProperties(ontologyManager, reasoner);
    }

    public Stream<OWLNamedIndividual> objectPropertyValues(OWLNamedIndividual fromIndividual, IRI propertyIri) {
        OWLObjectProperty property = this.ontologyManager.getOWLDataFactory().getOWLObjectProperty(propertyIri);
        return this.reasoner.objectPropertyValues(fromIndividual, (OWLObjectPropertyExpression)property);
    }

    public List<OWLNamedIndividual> getObjectPropertyValues(OWLNamedIndividual fromIndividual, IRI propertyIri) {
        return this.objectPropertyValues(fromIndividual, propertyIri).collect(Collectors.toList());
    }
}

