/*
 * Decompiled with CFR 0.152.
 */
package de.jpdigital.owlapisimplex;

import de.jpdigital.owlapisimplex.OwlApiSimplexException;
import de.jpdigital.owlapisimplex.OwlApiSimplexUtils;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import openllet.owlapi.OpenlletReasonerFactory;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.reasoner.OWLReasoner;

public abstract class OwlApiSimplexUtilsBuilder {
    private final OWLOntologyManager ontologyManager = OWLManager.createConcurrentOWLOntologyManager();

    OwlApiSimplexUtilsBuilder() {
    }

    protected OWLOntologyManager getOntologyManager() {
        return this.ontologyManager;
    }

    protected OWLOntology loadOntology(InputStream inputStream) throws OWLOntologyCreationException {
        return this.ontologyManager.loadOntologyFromOntologyDocument(Objects.requireNonNull(inputStream, "Can't load an ontology form an null InputStream"));
    }

    protected abstract List<OWLOntology> loadOntologies() throws OwlApiSimplexException;

    protected void validate(List<OWLOntology> ontologies) throws OwlApiSimplexException {
    }

    public OwlApiSimplexUtils build() throws OwlApiSimplexException {
        List<OWLOntology> ontologies = this.loadOntologies();
        this.validate(ontologies);
        OWLOntology ontology = ontologies.get(ontologies.size() - 1);
        OpenlletReasonerFactory reasonerFactory = new OpenlletReasonerFactory();
        OWLReasoner reasoner = reasonerFactory.createReasoner(ontology);
        return new OwlApiSimplexUtils(ontology, this.getOntologyManager(), reasoner);
    }
}

