/*
 * Decompiled with CFR 0.152.
 */
package de.jpdigital.owlapisimplex;

import de.jpdigital.owlapisimplex.OwlApiSimplexException;
import de.jpdigital.owlapisimplex.OwlApiSimplexUtilsBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;

public class OwlApiSimplexUtilsFromPathsBuilder
extends OwlApiSimplexUtilsBuilder {
    private final List<Path> paths;

    public OwlApiSimplexUtilsFromPathsBuilder(List<Path> paths) {
        this.paths = paths;
    }

    @Override
    protected List<OWLOntology> loadOntologies() throws OwlApiSimplexException {
        ArrayList<OWLOntology> ontologies = new ArrayList<OWLOntology>();
        for (Path path : this.paths) {
            if (!Files.exists(path, new LinkOption[0])) {
                throw new OwlApiSimplexException(String.format("File %s does not exist.", path.toString()));
            }
            if (!Files.isReadable(path)) {
                throw new OwlApiSimplexException(String.format("File %s is not readable.", path.toString()));
            }
            try {
                InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);
                Throwable throwable = null;
                try {
                    OWLOntology ontology = this.loadOntology(inputStream);
                    ontologies.add(ontology);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
            catch (IOException | OWLOntologyCreationException ex) {
                throw new OwlApiSimplexException(String.format("Failed to load ontology from OWL file %s", path.toString()), (Exception)ex);
            }
        }
        return ontologies;
    }
}

