/*
 * Decompiled with CFR 0.152.
 */
package de.jpdigital.owlapisimplex;

import de.jpdigital.owlapisimplex.OwlApiSimplexException;
import de.jpdigital.owlapisimplex.OwlApiSimplexUtilsBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;

public class OwlApiSimplexUtilsFromResourcesBuilder
extends OwlApiSimplexUtilsBuilder {
    private final List<String> resourcePaths;

    public OwlApiSimplexUtilsFromResourcesBuilder(List<String> resourcePaths) {
        this.resourcePaths = resourcePaths;
    }

    @Override
    public List<OWLOntology> loadOntologies() throws OwlApiSimplexException {
        ArrayList<OWLOntology> ontologies = new ArrayList<OWLOntology>();
        for (String resourcePath : this.resourcePaths) {
            try {
                InputStream inputStream = this.getClass().getResourceAsStream(resourcePath);
                Throwable throwable = null;
                try {
                    OWLOntology ontology = this.loadOntology(inputStream);
                    ontologies.add(ontology);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
            catch (IOException | OWLOntologyCreationException ex) {
                throw new OwlApiSimplexException(String.format("Failed to load ontology from OWL file resource %s", resourcePath), (Exception)ex);
            }
        }
        return ontologies;
    }
}

