/**
 * QueryGenerator.java
 * <p>
 * Copyright (c) 2007, JULIE Lab.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * <p>
 * Author: tomanek
 * <p>
 * Current version: 2.0
 * Since version:   1.5
 * <p>
 * Creation date: Oct 30, 2007
 * <p>
 * Builds a boolean query where each token of the search string is added SHOULD (OR).
 **/

package de.julielab.gene.candidateretrieval;

import de.julielab.geneexpbase.candidateretrieval.CandidateCacheKey;
import de.julielab.geneexpbase.candidateretrieval.QueryGenerator;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.*;
import org.apache.lucene.search.BooleanClause.Occur;
import org.apache.lucene.search.BooleanQuery.Builder;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class BooleanQueryGenerator extends QueryGenerator {

    private final Occur occur;
    private final int numAllowedNotToMatch;

    public BooleanQueryGenerator(Occur occur, int numAllowedNotToMatch) {
        this.occur = occur;
        this.numAllowedNotToMatch = numAllowedNotToMatch;
    }

    @Override
    public Query generateQuery(CandidateCacheKey key)
            throws BooleanQuery.TooManyClauses {
        String normalizedName = key.getGeneName().getNormalizedText();
        List<Query> disjuncts = new ArrayList<>();
        Query normalizedNameQueryDisjunctive = GeneNameQueries.makeBooleanQuery(normalizedName,
                SynonymIndexFieldNames.LOOKUP_SYN_FIELD, occur, numAllowedNotToMatch);

        String searchString = normalizedName.replaceAll("receptor", "r").trim();
        Query normalizedNameQueryDisjunctiveShort = null;
        if (!searchString.equals(normalizedName)) {
            normalizedNameQueryDisjunctiveShort = GeneNameQueries.makeBooleanQuery(searchString,
                    SynonymIndexFieldNames.LOOKUP_SYN_FIELD, occur, numAllowedNotToMatch);
        }


//        String[] s = normalizedName.split(" ");
//        for (int i = 0; i < s.length; i++) {
//            String t = s[i];
//            SnowballFilter ts = new SnowballFilter(new WhitespaceAnalyzer().tokenStream("", t), "English");
//            CharTermAttribute cta = ts.addAttribute(CharTermAttribute.class);
//            try {
//                ts.reset();
//                ts.incrementToken();
//                s[i] = new String(cta.buffer(), 0, cta.length());
//            } catch (IOException e) {
//                e.printStackTrace();
//            }
//        }
//        Query stemmedNormalizedQuery = GeneNameQueries.makeBooleanQuery(String.join(" ", s), SynonymIndexFieldNames.LOOKUP_SYN_FIELD_STEMMED, occur, numAllowedNotToMatch);


        disjuncts.add(normalizedNameQueryDisjunctive);
        if (normalizedNameQueryDisjunctiveShort != null)
            disjuncts.add(normalizedNameQueryDisjunctiveShort);
//        disjuncts.add(stemmedNormalizedQuery);

        disjuncts = disjuncts.stream().filter(Objects::nonNull).collect(Collectors.toList());
        DisjunctionMaxQuery disjunctionMaxQuery = new DisjunctionMaxQuery(disjuncts, 0f);
        BooleanClause fc = null;
        Builder builder = new BooleanQuery.Builder().add(disjunctionMaxQuery, Occur.MUST);
        if (key.getGeneIdsFilter() != null && !key.getGeneIdsFilter().isEmpty())
            fc = new BooleanClause(GeneNameQueries.makeBooleanQuery(String.join(" ", key.getGeneIdsFilter()), SynonymIndexFieldNames.ID_FIELD, Occur.SHOULD, -1), Occur.FILTER);
        if (fc != null)
            builder.add(fc);

        if (!StringUtils.isBlank(key.getTaxId())) {
            builder.add(new TermQuery(new Term(SynonymIndexFieldNames.TAX_ID_FIELD, key.getTaxId())), Occur.FILTER).build();
        }
        return builder.build();
    }

    @Override
    public String getName() {
        return "boolean-" + occur + "-" + numAllowedNotToMatch;
    }

}
