package de.julielab.gene.candidateretrieval;

import de.julielab.geneexpbase.candidateretrieval.QueryGenerator;
import de.julielab.geneexpbase.candidateretrieval.SynHit;
import de.julielab.geneexpbase.configuration.Parameters;
import de.julielab.geneexpbase.genemodel.GeneMention;
import de.julielab.geneexpbase.genemodel.GeneName;
import de.julielab.geneexpbase.scoring.TFIDFScorer;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.lucene.search.spell.SpellChecker;

import java.io.Closeable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;


public interface CandidateRetrieval extends de.julielab.geneexpbase.candidateretrieval.CandidateRetrieval, Closeable {
	List<SynHit> getCandidates(String originalSearchTerm, QueryGenerator queryGenerator);

	List<SynHit> getCandidates(GeneMention geneMention, String organism, QueryGenerator queryGenerator);

	List<SynHit> getCandidates(String geneMentionText, String organism, QueryGenerator queryGenerator);

	List<SynHit> getCandidates(String geneMentionText, Collection<String> organism, QueryGenerator queryGenerator);

    List<SynHit> getCandidates(GeneMention geneMention, Collection<String> geneIdsFilter, Collection<String> organisms, boolean loadFields, Parameters parameters, QueryGenerator queryGenerator);

    List<SynHit> getCandidates(String geneMentionText, Collection<String> geneIdsFilter, Collection<String> organism, QueryGenerator queryGenerator);

	List<SynHit> scoreIdsByBoWSynonyms(Collection<String> allSynonyms, Set<String> ids, QueryGenerator disjunction);

	List<SynHit> getCandidates(GeneMention gm, Collection<String> taxId, Parameters parameters, QueryGenerator queryGenerator);

    void close();

	/**
	 * Searches the index for the given gene mention filtered for family names.
	 * @param gm The gene mention to check for family names.
	 * @param queryGenerator The query generator to use.
	 * @return
	 */
	List<SynHit> getFamilyNames(GeneMention gm, QueryGenerator queryGenerator);

	List<SynHit> getOriginalNamesIndexRecords(Collection<String> geneIds, GeneName geneName);

	List<SynHit> getOriginalNamesIndexRecords(Collection<String> geneIds);

	TFIDFScorer getTFIDFOnGeneRecordNames();

	void setFulltextFieldsToRecordHits(Collection<? extends SynHit> recordHits, Collection<String> recordContextFieldNames);

	Pair<Map<String, Double>, Map<String, Set<String>>> scoreSynonymsRecordIndex (String queryType, Map<String, Collection<GeneName>> ids2entities, Function<GeneRecordHit, String[]> synhit2namesFunc, QueryGenerator qg);

	SpellChecker getSpellingChecker();
}
