package de.julielab.gene.candidateretrieval;

import java.io.File;
import java.io.IOException;

public class Configuration extends de.julielab.geneexpbase.configuration.Configuration {
    public static final String PREFIX_CANDIDATE_RETRIEVAL = "candidate_retrieval";

    public static final String USE_LUCENE_CANDIDATES_CACHE = "use_lucene_candidates_cache";

    public static final String PARAM_DISMAX_TIE_BREAKER = "dismax_tie_breaker";

    public static final String EXACT_SCORER_TYPE = "exact_scorer_type";
    public static final String APPROX_SCORER_TYPE = "approx_scorer_type";
    public static final String SPELLING_INDEX = "spelling_index";
    public static final String GENE_RECORD_INDEX = "gene_record_index";
    public static final String NAME_CENTRIC_INDEX   = "name_centric_index";
    public static final String GENE_RECORD_ORIGINAL_NAMES_INDEX = "gene_record_original_names_index";



    public Configuration(de.julielab.geneexpbase.configuration.Configuration baseConfiguration) {
        super(baseConfiguration);
    }

    // Candidate re-ranking parameters
    /**
     * Whether to use field weights in the Lucene query to the candidate index.
     */
    public static final String PARAM_USE_QUERY_FIELD_WEIGHTS =  "use_query_field_weights";
    public static final String PARAM_SORT_CANDIDATES_BY_MATCHED_FIELD = "sort_candidates_by_matched_field";

    private static final long serialVersionUID = 8883084080210596627L;

    public Configuration() {
    }

    public Configuration(String... parameters) {
        super(parameters);
    }

    public Configuration(File configurationFile) throws IOException {
        super(configurationFile);
    }
}
