package de.julielab.gene.candidateretrieval;

public class SynonymIndexFieldNames {
	public static final String ID_FIELD = "entry_id";
	// For the old BC2 evaluation indexes
	public static final String ID_FIELD_LEGACY = "uniprot_id";
	// public static final String SYN_FIELD = "synonym";
	/**
	 * The index field name for the normalized gene / protein name.
	 */
	public static final String LOOKUP_SYN_FIELD = "indexed_syn";
	public static final String LOOKUP_SYN_FIELD_STEMMED = "indexed_syn_stemmed";
	public static final String LOOKUP_SYN_FIELD_NGRAMS = "indexed_syn_ngrams";
	public static final String LOOKUP_SYN_FIELD_EXACT = "indexed_syn_exact";
	/**
	 * The index field name for the original, unnormalized (however, lower-cased)
	 * gene / protein name.
	 */
	public static final String ORIGINAL_NAME = "original_name";
	/**
	 * The index field name for the normalized variant of the original gene /
	 * protein name.
	 */
	public static final String VARIANT_NAME = "variant_name";
	/**
	 * The index field name for the normalized and then token-wise stemmed gene /
	 * protein name.
	 */
	public static final String STEMMED_NORMALIZED_NAME = "stemmed_normalized_name";
	public static final String TAX_ID_FIELD = "tax_id";
	/**
	 * A numerical priority where 1 is the highest priority. The highest priority is
	 * given to official symbols, preferred names etc.
	 */
	public static final String PRIORITY = "priority";
	/**
	 * A boolean-numerical (0 or 1) value to indicate whether the value was
	 * recognized as being unspecific or otherwise non-helpful. For experimental
	 * purposes, these items are kept in the index with this flag set to 1.
	 */
	public static final String FILTERED = "filtered";
	/**
	 * The source of the ID, e.g. into which database do we map?
	 */
	public static final String SOURCE = "source";
	/**
	 * The type of the entity denoted by this synonym, gene, protein or family.
	 */
	public static final String ENTITY_TYPE = "entity_type";

	public static final String CHROMOSOME = "chromosome";
	public static final String DESCRIPTION = "description";
	public static final String GENERIF = "generif";
	public static final String GODESC = "godesc";
	public static final String INTERACTION = "interaction";
	public static final String MAPLOCATION = "maplocation";
	public static final String SUMMARY = "summary";
	public static final String ECNUMBER = "ecnumber";

	public static final String VALUE_FAMILY_ID_PREFIX = "GENO\\:";

	/**
	 * Priority -1
	 */
	public static final String SYMBOL = "symbol";
	/**
	 * Priority 0
	 */
	public static final String SYMBOL_FROM_NOMCENCLATURE = "symbol_from_nomenclature";
	/**
	 * Priority 1
	 */
	public static final String FULL_NAMES = "full_names";
	/**
	 * Priority 2
	 */
	public static final String SYNONYMS = "synonyms";
	/**
	 * Priority 3
	 */
	public static final String OTHER_DESIGNATIONS = "other_designations";
	/**
	 * Priority 4
	 */
	public static final String PROTEIN_NAMES = "protein_names";
	/**
	 * Priority 5
	 */
	public static final String UNIPROT_NAMES = "uniprot_names";
	/**
	 * Priority 6
	 */
	public static final String XREFS = "xrefs";
	/**
	 * Priority 7
	 */
	public static final String BIO_THESAURUS = "bio_thesaurus";

}
