package de.julielab.gene.candidateretrieval.ioc;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import de.julielab.gene.candidateretrieval.CandidateRetrieval;
import de.julielab.gene.candidateretrieval.GeneRecordQueryGenerator;
import de.julielab.gene.candidateretrieval.LuceneCandidateRetrieval;
import de.julielab.gene.candidateretrieval.NameCentricRetrieval;
import de.julielab.geneexpbase.candidateretrieval.QueryGenerator;
import de.julielab.geneexpbase.configuration.Configuration;
import de.julielab.geneexpbase.ioc.BaseModule;

import javax.inject.Named;
import javax.inject.Singleton;

public class IndexModule extends AbstractModule {
    private final Configuration configuration;

    public IndexModule(de.julielab.geneexpbase.configuration.Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    protected void configure() {
        super.configure();
        bind(de.julielab.gene.candidateretrieval.Configuration.class).toInstance(new de.julielab.gene.candidateretrieval.Configuration(configuration));
        bind(NameCentricRetrieval.class).in(Singleton.class);
        bind(CandidateRetrieval.class).to(LuceneCandidateRetrieval.class).in(Singleton.class);
        // LuceneCandidateRetrieval is also bound to the base interface which is used in non-genemapper code
        bind(de.julielab.geneexpbase.candidateretrieval.CandidateRetrieval.class).to(LuceneCandidateRetrieval.class).in(Singleton.class);
//        bind(QueryGenerator.class).to(GeneRecordQueryGenerator.class);
        bind(QueryGenerator.class).toInstance(new GeneRecordQueryGenerator(false, true));
    }

    @Provides
    @Named(BaseModule.ID_INFERENCE)
    QueryGenerator provideQueryGenerator4IdInference(de.julielab.gene.candidateretrieval.Configuration configuration) {
        return LuceneCandidateRetrieval.GENE_RECORDS_CNF;
    }

}
