/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.gene.candidateretrieval;

import de.julielab.gene.candidateretrieval.GeneNameQueries;
import de.julielab.geneexpbase.candidateretrieval.CandidateCacheKey;
import de.julielab.geneexpbase.candidateretrieval.QueryGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class BooleanQueryGenerator
extends QueryGenerator {
    private final BooleanClause.Occur occur;
    private final int numAllowedNotToMatch;

    public BooleanQueryGenerator(BooleanClause.Occur occur, int numAllowedNotToMatch) {
        this.occur = occur;
        this.numAllowedNotToMatch = numAllowedNotToMatch;
    }

    public Query generateQuery(CandidateCacheKey key) throws BooleanQuery.TooManyClauses {
        String normalizedName = key.getGeneName().getNormalizedText();
        List<Object> disjuncts = new ArrayList<Query>();
        Query normalizedNameQueryDisjunctive = GeneNameQueries.makeBooleanQuery(normalizedName, "indexed_syn", this.occur, this.numAllowedNotToMatch);
        String searchString = normalizedName.replaceAll("receptor", "r").trim();
        Query normalizedNameQueryDisjunctiveShort = null;
        if (!searchString.equals(normalizedName)) {
            normalizedNameQueryDisjunctiveShort = GeneNameQueries.makeBooleanQuery(searchString, "indexed_syn", this.occur, this.numAllowedNotToMatch);
        }
        disjuncts.add(normalizedNameQueryDisjunctive);
        if (normalizedNameQueryDisjunctiveShort != null) {
            disjuncts.add(normalizedNameQueryDisjunctiveShort);
        }
        disjuncts = disjuncts.stream().filter(Objects::nonNull).collect(Collectors.toList());
        DisjunctionMaxQuery disjunctionMaxQuery = new DisjunctionMaxQuery(disjuncts, 0.0f);
        BooleanClause fc = null;
        BooleanQuery.Builder builder = new BooleanQuery.Builder().add((Query)disjunctionMaxQuery, BooleanClause.Occur.MUST);
        if (key.getGeneIdsFilter() != null && !key.getGeneIdsFilter().isEmpty()) {
            fc = new BooleanClause(GeneNameQueries.makeBooleanQuery(String.join((CharSequence)" ", key.getGeneIdsFilter()), "entry_id", BooleanClause.Occur.SHOULD, -1), BooleanClause.Occur.FILTER);
        }
        if (fc != null) {
            builder.add(fc);
        }
        if (!StringUtils.isBlank((CharSequence)key.getTaxId())) {
            builder.add((Query)new TermQuery(new Term("tax_id", key.getTaxId())), BooleanClause.Occur.FILTER).build();
        }
        return builder.build();
    }

    public String getName() {
        return "boolean-" + this.occur + "-" + this.numAllowedNotToMatch;
    }
}

