/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.gene.candidateretrieval;

import de.julielab.gene.candidateretrieval.GeneRecordQueryGenerator;
import de.julielab.geneexpbase.TermNormalizer;
import de.julielab.geneexpbase.candidateretrieval.SynHit;
import de.julielab.geneexpbase.genemodel.GeneMention;
import de.julielab.geneexpbase.genemodel.Specifier;
import de.julielab.geneexpbase.genemodel.SpecifierType;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class GeneRecordHit
extends SynHit {
    private String symbol;
    private String nomenclature;
    private String chromosome;
    private String mapLocation;
    private double synonymSimilarityScore;
    private String synonymField;
    private String[] fullNames;
    private String[] synonyms;
    private String[] otherDesignations;
    private String[] uniprotNames;
    private String[] bioThesaurusNames;
    private String[] xrefs;
    private String[] geneRifs;
    private String[] interactions;
    private String[] descriptions;
    private String[] summaries;
    private String[] goDescriptors;
    private Set<String> nameTokens;
    private transient TermNormalizer termNormalizerLatinNumbers = new TermNormalizer();
    private String ecNumber;

    public GeneRecordHit(String syn, double score, String id, String source) {
        super(syn, score, id, source);
        this.setId(id);
    }

    public static Comparator<SynHit> getNormalizedExactMatchThenLuceneScoreComparator(String geneName, boolean sortByMatchingField) {
        Comparator<SynHit> comparator = Comparator.comparing(sh -> sh.getSynonym().equals(geneName));
        comparator = comparator.thenComparingDouble(sh -> sh.getLuceneScore()).reversed();
        if (sortByMatchingField) {
            comparator = comparator.thenComparingInt(sh -> {
                if (sh instanceof GeneRecordHit) {
                    return -1 * GeneRecordQueryGenerator.ALL_FIELDS_LIST.indexOf(((GeneRecordHit)((Object)sh)).getSynonymField());
                }
                return 0;
            });
        }
        return comparator;
    }

    public Stream<String> getCommonTokens(GeneMention gm) {
        Set nameTokenSet = gm.getNameTokenSet();
        Set<String> grhTokens = this.getNormalizedGeneNameTokenSet();
        return grhTokens.stream().filter(nameTokenSet::contains);
    }

    public String getChromosome() {
        return this.chromosome;
    }

    public void setChromosome(String chromosome) {
        this.chromosome = chromosome;
    }

    public String getMapLocation() {
        return this.mapLocation;
    }

    public void setMapLocation(String mapLocation) {
        this.mapLocation = mapLocation;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public String getSymbolFromNomenclature() {
        return this.nomenclature;
    }

    public void setNomenclature(String nomenclature) {
        this.nomenclature = nomenclature;
    }

    public String[] getFullNames() {
        return this.fullNames;
    }

    public void setFullNames(String[] fullNames) {
        this.fullNames = fullNames;
    }

    public String[] getSynonyms() {
        return this.synonyms;
    }

    public void setSynonyms(String[] synonyms) {
        this.synonyms = synonyms;
    }

    public String[] getOtherDesignations() {
        return this.otherDesignations;
    }

    public void setOtherDesignations(String[] otherDesignations) {
        this.otherDesignations = otherDesignations;
    }

    public String[] getUniprotNames() {
        return this.uniprotNames;
    }

    public void setUniprotNames(String[] uniprotNames) {
        this.uniprotNames = uniprotNames;
    }

    public String[] getBioThesaurusNames() {
        return this.bioThesaurusNames;
    }

    public void setBioThesaurusNames(String[] bioThesaurusNames) {
        this.bioThesaurusNames = bioThesaurusNames;
    }

    public String[] getXrefs() {
        return this.xrefs;
    }

    public void setXrefs(String[] xrefs) {
        this.xrefs = xrefs;
    }

    public double getSynonymSimilarityScore() {
        return this.synonymSimilarityScore;
    }

    public void setSynonymSimilarityScore(double synonymTokenJaroScore) {
        this.synonymSimilarityScore = synonymTokenJaroScore;
    }

    public String getSynonymField() {
        return this.synonymField;
    }

    public void setSynonymField(String synonymField) {
        this.synonymField = synonymField;
    }

    public String[] getGeneRifs() {
        return this.geneRifs;
    }

    public void setGeneRifs(String[] geneRifs) {
        this.geneRifs = geneRifs;
    }

    public String[] getInteractions() {
        return this.interactions;
    }

    public void setInteractions(String[] interactions) {
        this.interactions = interactions;
    }

    public String[] getDescriptions() {
        return this.descriptions;
    }

    public void setDescriptions(String[] descriptions) {
        this.descriptions = descriptions;
    }

    public String[] getSummaries() {
        return this.summaries;
    }

    public void setSummaries(String[] summaries) {
        this.summaries = summaries;
    }

    public String[] getGoDescriptors() {
        return this.goDescriptors;
    }

    public void setGoDescriptors(String[] goDescriptors) {
        this.goDescriptors = goDescriptors;
    }

    public Set<String> getNormalizedGeneNameTokenSet() {
        if (this.nameTokens == null) {
            Stream<String> grhTokens = this.getNormalizedGeneNameTokens();
            this.nameTokens = grhTokens.filter(Objects::nonNull).collect(Collectors.toSet());
        }
        return this.nameTokens;
    }

    @NotNull
    private Stream<String> getNormalizedGeneNameTokens() {
        if (this.termNormalizerLatinNumbers == null) {
            this.termNormalizerLatinNumbers = new TermNormalizer();
        }
        Function<String, Stream<String>> strTokensFunc = str -> str != null ? Arrays.stream(this.termNormalizerLatinNumbers.normalize(str).split("\\s+")) : Stream.empty();
        Stream<String> grhTokens = this.getGeneNameTokens(strTokensFunc);
        return grhTokens;
    }

    @NotNull
    private Stream<String> getGeneNameTokens(Function<String, Stream<String>> tokenizerFunc) {
        return this.getGeneNames().flatMap(tokenizerFunc);
    }

    public Stream<String> getGeneNames() {
        Stream<String> grhTokens = Stream.of(this.getSymbol());
        grhTokens = Stream.concat(grhTokens, Arrays.stream(this.getFullNames()));
        grhTokens = Stream.concat(grhTokens, Stream.of(this.getSymbolFromNomenclature()));
        grhTokens = Stream.concat(grhTokens, Arrays.stream(this.getSynonyms()));
        grhTokens = Stream.concat(grhTokens, Arrays.stream(this.getOtherDesignations()));
        grhTokens = Stream.concat(grhTokens, Arrays.stream(this.getUniprotNames()));
        grhTokens = Stream.concat(grhTokens, Arrays.stream(this.getBioThesaurusNames()));
        return grhTokens;
    }

    public Map<Specifier, Integer> getMajoritySpecifiers() {
        HashMap<Specifier, Integer> counts = new HashMap<Specifier, Integer>();
        Iterator iterator = this.getGeneNames().iterator();
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            this.termNormalizerLatinNumbers.getGreekCharacters(name).map(s -> new Specifier(SpecifierType.GREEK, s)).forEach(s -> counts.merge((Specifier)s, 1, Integer::sum));
            this.termNormalizerLatinNumbers.getRomanNumbers(name).map(s -> new Specifier(SpecifierType.ROMAN, s)).forEach(s -> counts.merge((Specifier)s, 1, Integer::sum));
            this.termNormalizerLatinNumbers.getNumbers(name).map(s -> new Specifier(SpecifierType.NUMERICAL, s)).forEach(s -> counts.merge((Specifier)s, 1, Integer::sum));
        }
        Specifier maxGreek = null;
        Specifier maxRoman = null;
        Specifier maxNum = null;
        int maxGreekCount = 0;
        int maxRomanCount = 0;
        int maxNumCount = 0;
        for (Specifier key : counts.keySet()) {
            int count = (Integer)counts.get(key);
            switch (key.getSpecifierType()) {
                case NUMERICAL: {
                    if (maxNum == null || maxNumCount < count) {
                        maxNum = key;
                    }
                    maxNumCount = count;
                    break;
                }
                case ROMAN: {
                    if (maxRoman == null || maxRomanCount < count) {
                        maxRoman = key;
                    }
                    maxRomanCount = count;
                    break;
                }
                case GREEK: {
                    if (maxGreek == null || maxGreekCount < count) {
                        maxGreek = key;
                    }
                    maxGreekCount = count;
                }
            }
        }
        HashMap<Specifier, Integer> ret = new HashMap<Specifier, Integer>();
        if (maxGreek != null) {
            ret.put(maxGreek, maxGreekCount);
        }
        if (maxRoman != null) {
            ret.put(maxRoman, maxRomanCount);
        }
        if (maxNum != null) {
            ret.put(maxNum, maxNumCount);
        }
        return counts;
    }

    public void setEcNumber(String ecNumber) {
        this.ecNumber = ecNumber;
    }

    public String getEcNumber() {
        return this.ecNumber;
    }
}

