/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.gene.candidateretrieval;

import com.google.common.cache.LoadingCache;
import de.julielab.gene.candidateretrieval.BooleanQueryGenerator;
import de.julielab.gene.candidateretrieval.CandidateRetrieval;
import de.julielab.gene.candidateretrieval.Configuration;
import de.julielab.gene.candidateretrieval.GeneRecordHit;
import de.julielab.gene.candidateretrieval.GeneRecordQueryGenerator;
import de.julielab.gene.candidateretrieval.LuceneCandidateRetrieval;
import de.julielab.gene.candidateretrieval.NGramQueryGenerator;
import de.julielab.gene.candidateretrieval.scoring.LuceneScorer;
import de.julielab.gene.candidateretrieval.scoring.MaxEntScorer;
import de.julielab.geneexpbase.GeneExpRuntimeException;
import de.julielab.geneexpbase.TermNormalizer;
import de.julielab.geneexpbase.candidateretrieval.CandidateCacheKey;
import de.julielab.geneexpbase.candidateretrieval.GeneCandidateRetrievalException;
import de.julielab.geneexpbase.candidateretrieval.QueryGenerator;
import de.julielab.geneexpbase.candidateretrieval.SynHit;
import de.julielab.geneexpbase.configuration.Parameters;
import de.julielab.geneexpbase.genemodel.GeneMention;
import de.julielab.geneexpbase.genemodel.GeneName;
import de.julielab.geneexpbase.scoring.JaroWinklerScorer;
import de.julielab.geneexpbase.scoring.LevenshteinScorer;
import de.julielab.geneexpbase.scoring.Scorer;
import de.julielab.geneexpbase.scoring.SimpleScorer;
import de.julielab.geneexpbase.scoring.TFIDFScorer;
import de.julielab.geneexpbase.scoring.TFIDFUtils;
import de.julielab.geneexpbase.scoring.TokenJaroSimilarityScorer;
import de.julielab.geneexpbase.services.CacheService;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.cache.Cache;
import javax.inject.Inject;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.custom.CustomAnalyzer;
import org.apache.lucene.analysis.ngram.NGramFilterFactory;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.StandardDirectoryReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.search.similarities.ClassicSimilarity;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.search.spell.SpellChecker;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.QueryBuilder;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NameCentricRetrieval
implements CandidateRetrieval {
    public static final QueryGenerator CONJUNCTION = new BooleanQueryGenerator(BooleanClause.Occur.MUST, 0);
    public static final QueryGenerator DISJUNCTION = new BooleanQueryGenerator(BooleanClause.Occur.SHOULD, -1);
    public static final QueryGenerator DISJUNCTION_MINUS_1 = new BooleanQueryGenerator(BooleanClause.Occur.SHOULD, 1);
    public static final QueryGenerator DISJUNCTION_MINUS_2 = new BooleanQueryGenerator(BooleanClause.Occur.SHOULD, 2);
    public static final QueryGenerator NGRAM_2_3 = new NGramQueryGenerator(2, 3);
    public static final String NAME_PRIO_DELIMITER = "__";
    public static final String LOGGER_NAME_CANDIDATES = "de.julielab.jules.ae.genemapper.candidates";
    public static final int SIMPLE_SCORER = 0;
    public static final int TOKEN_JAROWINKLER_SCORER = 1;
    public static final int MAXENT_SCORER = 2;
    public static final int JAROWINKLER_SCORER = 3;
    public static final int LEVENSHTEIN_SCORER = 4;
    public static final int TFIDF = 5;
    public static final int LUCENE_SCORER = 10;
    public static final String MAXENT_SCORER_MODEL = "/genemapper_jules_mallet.mod";
    public static final Logger candidateLog = LoggerFactory.getLogger((String)"de.julielab.jules.ae.genemapper.candidates");
    public static final int LUCENE_MAX_HITS = 20;
    private static final Logger log = LoggerFactory.getLogger(LuceneCandidateRetrieval.class);
    private static final ConcurrentHashMap<String, LoadingCache<CandidateCacheKey, List<SynHit>>> caches = new ConcurrentHashMap();
    private static final AtomicLong totalCacheGettime = new AtomicLong();
    private static final AtomicLong totalCachePuttime = new AtomicLong();
    private static final AtomicLong totalLuceneQueryTime = new AtomicLong();
    private static final Map<Thread, IndexSearcher> mentionIndexSearcher = new ConcurrentHashMap<Thread, IndexSearcher>();
    private static final Map<Thread, IndexSearcher> geneRecordIndexSearcher = new ConcurrentHashMap<Thread, IndexSearcher>();
    private static ExecutorService executorService;
    private final Map<String, Float> globalFieldWeights;
    private final Scorer exactScorer;
    private final Scorer approxScorer;
    private final Cache<CandidateCacheKey, List> candidateCache;
    private final Configuration configuration;
    private final IndexReader geneRecordIndexReader;
    private final IndexReader nameCentricIndexReader;
    private final Boolean useLuceneCandidateCache;
    private CustomAnalyzer ngramAnalyzer;
    private String maxEntModel = "/genemapper_jules_mallet.mod";
    private TermNormalizer normalizer;
    private SpellChecker spellingChecker;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject
    public NameCentricRetrieval(Configuration config, CacheService cacheService) throws GeneCandidateRetrievalException {
        this.configuration = config;
        this.useLuceneCandidateCache = config.getBoolean("use_lucene_candidates_cache").orElse(false);
        String mentionIndex = config.getProperty("name_centric_index");
        if (mentionIndex == null) {
            throw new GeneCandidateRetrievalException("mention index not specified in configuration file (critical).");
        }
        String geneRecordIndex = config.getProperty("gene_record_index");
        if (geneRecordIndex == null) {
            throw new GeneCandidateRetrievalException("geneRecordIndex index not specified in configuration file (critical).");
        }
        try {
            this.nameCentricIndexReader = DirectoryReader.open((Directory)FSDirectory.open((Path)Paths.get(mentionIndex, new String[0])));
            int luceneConcurrencyLevel = Integer.parseInt((String)config.getOrDefault("concurrency_level", "1"));
            Class<LuceneCandidateRetrieval> clazz = LuceneCandidateRetrieval.class;
            synchronized (LuceneCandidateRetrieval.class) {
                String scorerType;
                File spellingIndex;
                if (executorService == null) {
                    executorService = Executors.newFixedThreadPool(luceneConcurrencyLevel, new ThreadFactory(){
                        private final ThreadFactory tf = Executors.defaultThreadFactory();

                        @Override
                        public Thread newThread(@NotNull Runnable r) {
                            Thread t = this.tf.newThread(r);
                            t.setName("pool-lucene-candidate-retrieval");
                            return t;
                        }
                    });
                }
                // ** MonitorExit[var6_9] (shouldn't be in output)
                log.debug("mention index loaded.");
                this.geneRecordIndexReader = DirectoryReader.open((Directory)FSDirectory.open((Path)Paths.get(geneRecordIndex, new String[0])));
                log.info("Gene record index has {} segments", (Object)((StandardDirectoryReader)this.geneRecordIndexReader).getSegmentInfos().size());
                String spellingIndexPath = config.getProperty("spelling_index");
                if (spellingIndexPath != null && (spellingIndex = new File(spellingIndexPath)).exists()) {
                    this.spellingChecker = new SpellChecker((Directory)FSDirectory.open((Path)spellingIndex.toPath()));
                }
                if (this.spellingChecker == null) {
                    log.warn("Spelling index was not given or file does not exist. No spelling correction can be done. Specified spelling index: {}", (Object)spellingIndexPath);
                }
                if ((scorerType = config.getProperty("exact_scorer_type")) == null) {
                    log.debug("No configuration value given for exact_scorer_type");
                    this.exactScorer = this.setScorerType(10);
                } else {
                    this.exactScorer = this.setScorerType(Integer.valueOf(scorerType));
                }
                scorerType = config.getProperty("approx_scorer_type");
                if (scorerType == null) {
                    log.debug("No configuration value given for approx_scorer_type");
                    this.approxScorer = this.setScorerType(10);
                } else {
                    this.approxScorer = this.setScorerType(Integer.valueOf(scorerType));
                }
                String maxEntModel = config.getProperty("maxent_model");
                if (maxEntModel != null) {
                    this.maxEntModel = maxEntModel;
                }
                this.normalizer = new TermNormalizer();
            }
        }
        catch (IOException e) {
            throw new GeneCandidateRetrievalException((Throwable)e);
        }
        {
            OptionalDouble fieldWeight;
            log.info("Mention index: " + mentionIndex);
            log.info("Exact scorer: " + this.exactScorer);
            log.info("Approx scorer: " + this.approxScorer);
            this.candidateCache = cacheService.getCacheManager().getCache("candidates-cache-name-centric");
            try {
                HashMap<String, String> ngramFilterSettings = new HashMap<String, String>();
                ngramFilterSettings.put("minGramSize", "2");
                ngramFilterSettings.put("maxGramSize", "3");
                this.ngramAnalyzer = CustomAnalyzer.builder().withTokenizer("whitespace", new String[0]).addTokenFilter(NGramFilterFactory.class, ngramFilterSettings).build();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.globalFieldWeights = new HashMap<String, Float>();
            config.getDouble(Configuration.dot((String[])new String[]{"candidate_retrieval", "dismax_tie_breaker"})).ifPresent(d -> this.globalFieldWeights.put("dismax_tie_breaker", Float.valueOf((float)d)));
            for (String field : GeneRecordQueryGenerator.ALL_FIELDS) {
                fieldWeight = config.getDouble(Configuration.dot((String[])new String[]{"candidate_retrieval", field}));
                fieldWeight.ifPresent(d -> this.globalFieldWeights.put(field, Float.valueOf((float)d)));
            }
            for (String field : GeneRecordQueryGenerator.SYNONYM_FIELDS) {
                fieldWeight = config.getDouble(Configuration.dot((String[])new String[]{"candidate_retrieval", field + "_exact"}));
                fieldWeight.ifPresent(d -> this.globalFieldWeights.put(field, Float.valueOf((float)d)));
            }
            return;
        }
    }

    public static AtomicLong getTotalCacheGettime() {
        return totalCacheGettime;
    }

    public static AtomicLong getTotalCachePuttime() {
        return totalCachePuttime;
    }

    public static AtomicLong getTotalLuceneQueryTime() {
        return totalLuceneQueryTime;
    }

    public static void shutdownExecutor() {
        executorService.shutdown();
    }

    public TermNormalizer getNormalizer() {
        return this.normalizer;
    }

    public void setNormalizer(TermNormalizer normalizer) {
        this.normalizer = normalizer;
    }

    public Scorer getScorer() {
        return this.exactScorer;
    }

    @Override
    public SpellChecker getSpellingChecker() {
        return this.spellingChecker;
    }

    public Scorer setScorerType(int type) throws GeneCandidateRetrievalException {
        Object scorer;
        if (type == 0) {
            scorer = new SimpleScorer();
        } else if (type == 1) {
            scorer = new TokenJaroSimilarityScorer();
        } else if (type == 2) {
            if (!this.maxEntModel.equals(MAXENT_SCORER_MODEL)) {
                scorer = new MaxEntScorer(new File(this.maxEntModel));
            } else {
                InputStream in = this.getClass().getResourceAsStream(MAXENT_SCORER_MODEL);
                scorer = new MaxEntScorer(in);
            }
        } else if (type == 3) {
            scorer = new JaroWinklerScorer();
        } else if (type == 10) {
            scorer = new LuceneScorer();
        } else if (type == 4) {
            scorer = new LevenshteinScorer();
        } else if (type == 5) {
            Thread currentThread = Thread.currentThread();
            TFIDFUtils tfidfNormalizedName = new TFIDFUtils();
            tfidfNormalizedName.learnFromLuceneIndex(this.nameCentricIndexReader, "indexed_syn");
            scorer = new TFIDFScorer(tfidfNormalizedName);
        } else {
            throw new GeneCandidateRetrievalException("Unknown mention scorer type: " + type);
        }
        return scorer;
    }

    public String getScorerInfo() {
        if (this.exactScorer == null) {
            return "Lucene Score (unnormalized)";
        }
        return this.exactScorer.info();
    }

    public int getScorerType() {
        return this.exactScorer.getScorerType();
    }

    @Override
    public List<SynHit> getCandidates(String originalSearchTerm, QueryGenerator queryGenerator) {
        GeneMention geneMention = new GeneMention(originalSearchTerm, this.normalizer);
        return this.getCandidates(geneMention, queryGenerator);
    }

    public List<SynHit> getCandidates(GeneMention geneMention, QueryGenerator queryGenerator) {
        return this.getCandidates(geneMention, (Collection<String>)geneMention.getTaxonomyIds(), queryGenerator);
    }

    public List<SynHit> getCandidates(GeneMention geneMention, Collection<String> organisms, QueryGenerator queryGenerator) {
        return this.getCandidates(geneMention, null, organisms != null ? organisms : Collections.emptyList(), queryGenerator);
    }

    public List<SynHit> getCandidates(GeneMention geneMention, Collection<String> geneIdsFilter, Collection<String> organisms, QueryGenerator queryGenerator) {
        return this.getCandidates(geneMention, geneIdsFilter, organisms, true, null, queryGenerator);
    }

    @Override
    public List<SynHit> getCandidates(GeneMention geneMention, Collection<String> geneIdsFilter, Collection<String> organisms, boolean loadFields, Parameters parameters, QueryGenerator queryGenerator) {
        return this.getCandidates(geneMention, geneIdsFilter, organisms, loadFields, parameters, -1, queryGenerator);
    }

    public List<SynHit> getCandidates(GeneMention geneMention, Collection<String> geneIdsFilter, Collection<String> organisms, boolean loadFields, Parameters parameters, int numReturnedHits, QueryGenerator queryGenerator) {
        List<Object> hits = new ArrayList();
        CandidateCacheKey key = new CandidateCacheKey(geneMention.getGeneName());
        key.setLoadSynHitFields(loadFields);
        key.setQueryGenerator(queryGenerator);
        if (parameters != null && parameters.getBoolean(Configuration.dot((String[])new String[]{"candidate_retrieval", "use_query_field_weights"}))) {
            key.setFieldWeights(this.getFieldWeightsFromParameters((Map<String, Object>)parameters));
        }
        if (queryGenerator instanceof GeneRecordQueryGenerator && ((GeneRecordQueryGenerator)queryGenerator).isUseContextGenesAsRelevanceSignal()) {
            key.setContextNames((Collection)geneMention.getContextGeneNames().collect(Collectors.toSet()));
        }
        if (geneIdsFilter != null) {
            key.setGeneIdsFilter(geneIdsFilter);
        }
        if (numReturnedHits > 0) {
            key.setMaxHits(numReturnedHits);
        }
        if (organisms == null || organisms.isEmpty()) {
            hits = this.getCandidatesFromIndex(key);
            if (log.isDebugEnabled()) {
                int geneBegin = geneMention.getOffsets() != null ? geneMention.getBegin() : -1;
                int geneEnd = geneMention.getOffsets() != null ? geneMention.getEnd() : -1;
                log.debug("Returning {} candidates for gene mention {}[{}-{}]", new Object[]{hits.size(), key.getGeneName().getText(), geneBegin, geneEnd});
            }
        }
        if (organisms != null) {
            for (String taxonomyId : organisms) {
                key.setTaxId(taxonomyId);
                hits.addAll(this.getCandidatesFromIndex(key));
                if (!log.isDebugEnabled()) continue;
                int begin = -1;
                int end = -1;
                if (geneMention.getOffsets() != null) {
                    begin = geneMention.getBegin();
                    end = geneMention.getEnd();
                }
                log.debug("Returning {} candidates for gene mention {}[{}-{}] for taxonomy ID {}", new Object[]{hits.size(), key.getGeneName().getText(), begin, end, organisms});
            }
        }
        hits.stream().forEach(h -> h.setCompareType(SynHit.CompareType.SCORE));
        List<SynHit> sortedHits = hits.stream().sorted().collect(Collectors.toList());
        return sortedHits;
    }

    @Override
    public List<SynHit> getCandidates(String geneMentionText, Collection<String> geneIdsFilter, Collection<String> organism, QueryGenerator queryGenerator) {
        GeneMention geneMention = new GeneMention(geneMentionText, this.normalizer);
        return this.getCandidates(geneMention, geneIdsFilter, organism, queryGenerator);
    }

    public List<SynHit> getCandidates(String geneMentionText, Collection<String> geneIdsFilter, Collection<String> organism, boolean loadFields, QueryGenerator queryGenerator) {
        GeneMention geneMention = new GeneMention(geneMentionText, this.normalizer);
        return this.getCandidates(geneMention, geneIdsFilter, organism, queryGenerator);
    }

    private List<SynHit> getCandidatesFromIndex(CandidateCacheKey key) {
        List<SynHit> synHits;
        List<SynHit> list = synHits = this.useLuceneCandidateCache != false ? (List<SynHit>)this.candidateCache.get((Object)key) : null;
        if (synHits == null) {
            try {
                synHits = this.getCandidatesFromIndexWithoutCache(key);
            }
            catch (IOException e) {
                throw new GeneExpRuntimeException((Throwable)e);
            }
            this.candidateCache.put((Object)key, synHits);
        }
        try {
            return synHits.stream().map(SynHit::clone).collect(Collectors.toList());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private List<SynHit> getCandidatesFromIndexWithoutCache(CandidateCacheKey key) throws IOException, BooleanQuery.TooManyClauses {
        long luceneQueryTime = System.currentTimeMillis();
        Query searchQuery = key.generateQuery();
        TopDocs foundDocs = this.getNameCentricIndexSearcher().search(searchQuery, key.getMaxHits());
        log.debug("searching with query: " + searchQuery + "; found hits: " + foundDocs.totalHits);
        ArrayList<SynHit> synHits = this.scoreHits(foundDocs, key.getGeneName(), key.isLoadSynHitFields());
        luceneQueryTime = System.currentTimeMillis() - luceneQueryTime;
        totalLuceneQueryTime.addAndGet(luceneQueryTime);
        return synHits;
    }

    private ArrayList<SynHit> scoreHits(TopDocs foundDocs, GeneName geneName, boolean loadFields) throws CorruptIndexException, IOException {
        ArrayList<SynHit> allHits = new ArrayList<SynHit>();
        String originalMention = geneName.getText().toLowerCase();
        String normalizedMention = geneName.getNormalizedText();
        ScoreDoc[] scoredDocs = foundDocs.scoreDocs;
        log.debug("ordering candidates for best match to this reference term: " + originalMention + " for top " + scoredDocs.length + " candidates");
        candidateLog.trace("Search term: " + normalizedMention);
        IndexSearcher indexSearcher = this.getNameCentricIndexSearcher();
        for (int i = 0; i < scoredDocs.length; ++i) {
            Scorer scorer;
            int docID = scoredDocs[i].doc;
            Document d = indexSearcher.doc(docID);
            String indexNormalizedName = d.getField("indexed_syn").stringValue();
            ArrayList ids = new ArrayList();
            ArrayList priorities = new ArrayList();
            String source = null;
            String entityType = null;
            List taxIds = Collections.emptyList();
            Arrays.stream(d.getFields("entry_id")).map(IndexableField::stringValue).map(idAndSyn -> idAndSyn.split(NAME_PRIO_DELIMITER)).forEach(split -> {
                ids.add(split[0]);
                priorities.add(Integer.valueOf(split[1]));
            });
            if (loadFields) {
                source = d.getField("source").stringValue();
                entityType = d.getField("entity_type").stringValue();
                taxIds = Arrays.stream(d.getFields("tax_id")).map(IndexableField::stringValue).collect(Collectors.toList());
            }
            double score = 0.0;
            Scorer scorer2 = scorer = indexNormalizedName.equals(normalizedMention) ? this.exactScorer : this.approxScorer;
            score = scorer.getScorerType() == 10 ? (indexNormalizedName.equals(normalizedMention) ? 9999.0 : (double)scoredDocs[i].score) : scorer.getScore(normalizedMention, indexNormalizedName);
            SynHit m = new SynHit(indexNormalizedName, score, ids, source, entityType, taxIds);
            m.setMappedMention(originalMention);
            m.setMappedGeneName(geneName);
            m.setSynonymPriorities(priorities);
            m.setLuceneScore(scoredDocs[i].score);
            if (score == 9999.0) {
                m.setExactMatch(true);
            }
            allHits.add(m);
        }
        return allHits;
    }

    private List<SynHit> combineHits(List<SynHit> allHits) {
        HashMap<String, SynHit> hitList = new HashMap<String, SynHit>();
        for (SynHit currHit : allHits) {
            for (String id : currHit.getIds()) {
                if (hitList.containsKey(id)) {
                    SynHit oldHit = (SynHit)hitList.get(id);
                    if (!(currHit.getLexicalScore() >= oldHit.getLexicalScore())) continue;
                    hitList.put(id, currHit);
                    continue;
                }
                hitList.put(id, currHit);
            }
        }
        HashSet<SynHit> combinedHits = new HashSet<SynHit>();
        for (String id : hitList.keySet()) {
            SynHit currHit = (SynHit)hitList.get(id);
            currHit.setCompareType(SynHit.CompareType.SCORE);
            combinedHits.add(currHit);
        }
        return combinedHits.stream().sorted().collect(Collectors.toList());
    }

    @Override
    public List<SynHit> getCandidates(GeneMention geneMention, String organism, QueryGenerator queryGenerator) {
        return this.getCandidates(geneMention, organism != null ? Arrays.asList(organism) : Collections.emptyList(), queryGenerator);
    }

    @Override
    public List<SynHit> getCandidates(String geneMentionText, String organism, QueryGenerator queryGenerator) {
        return this.getCandidates(new GeneMention(geneMentionText, this.normalizer), organism != null ? Arrays.asList(organism) : Collections.emptyList(), queryGenerator);
    }

    @Override
    public List<SynHit> getCandidates(String geneMentionText, Collection<String> organism, QueryGenerator queryGenerator) {
        return this.getCandidates(new GeneMention(geneMentionText, this.normalizer), organism, queryGenerator);
    }

    public String mapGeneIdToTaxId(String geneId) {
        try {
            String fieldValue = geneId + "__-1";
            TermQuery idQuery = new TermQuery(new Term("entry_id", fieldValue));
            TermQuery geneTypeQuery = new TermQuery(new Term("entity_type", "Gene/Protein"));
            BooleanQuery geneIdQuery = new BooleanQuery.Builder().add((Query)idQuery, BooleanClause.Occur.MUST).add((Query)geneTypeQuery, BooleanClause.Occur.FILTER).build();
            IndexSearcher indexSearcher = this.getNameCentricIndexSearcher();
            TopDocs topDocs = indexSearcher.search((Query)geneIdQuery, 1);
            ScoreDoc[] scoredDocs = topDocs.scoreDocs;
            if (topDocs.totalHits.value > 0L) {
                int docID = scoredDocs[0].doc;
                Document d = indexSearcher.doc(docID);
                List ids = Arrays.stream(d.getFields("entry_id")).map(IndexableField::stringValue).map(idandprio -> idandprio.split(NAME_PRIO_DELIMITER)).map(split -> split[0]).collect(Collectors.toList());
                List taxIds = Arrays.stream(d.getFields("tax_id")).map(IndexableField::stringValue).collect(Collectors.toList());
                String taxId = "";
                for (int i = 0; i < ids.size(); ++i) {
                    if (!((String)ids.get(i)).equals(geneId)) continue;
                    taxId = (String)taxIds.get(i);
                }
                if (taxId.isBlank()) {
                    log.warn("GeneID: " + geneId + " has no TaxId assigned.");
                }
                return taxId;
            }
            log.warn("GeneID: " + geneId + " was not found in the index.");
            return "";
        }
        catch (IOException e) {
            throw new GeneExpRuntimeException((Throwable)e);
        }
    }

    public List<SynHit> getIndexEntries(List<String> ids) throws IOException {
        log.warn("LuceneCandidateRetrieval.getIndexEntries(): This method currently does not work as intended since the synonym index is now synonym-centric instead of id-centric. The ID field values have the form id_priority, thus at this place a wildcard query for all priorities would be needed");
        ArrayList<SynHit> entries = new ArrayList<SynHit>(ids.size());
        for (String id : ids) {
            BooleanClause clause = new BooleanClause((Query)new TermQuery(new Term("entry_id", id + "__-1")), BooleanClause.Occur.FILTER);
            BooleanQuery query = new BooleanQuery.Builder().add(clause).build();
            IndexSearcher indexSearcher = this.getNameCentricIndexSearcher();
            TopDocs result = indexSearcher.search((Query)query, 1);
            if (result.totalHits.value > 0L) {
                int docID = result.scoreDocs[0].doc;
                Document d = indexSearcher.doc(docID);
                String source = d.getField("source").stringValue();
                String entityType = d.getField("entity_type").stringValue();
                List taxIdField = Arrays.stream(d.getFields("tax_id")).map(IndexableField::stringValue).filter(tax -> !StringUtils.isBlank((CharSequence)tax)).collect(Collectors.toList());
                if (taxIdField.isEmpty()) {
                    log.warn("GeneID: " + id + " has no TaxId assigned.");
                }
                SynHit m = new SynHit("<none>", 0.0, Arrays.asList(id), source, entityType, taxIdField);
                entries.add(m);
            }
            entries.add(null);
        }
        return entries;
    }

    public List<SynHit> getIndexRecords(Collection<String> ids) throws IOException {
        ArrayList<SynHit> entries = new ArrayList<SynHit>(ids.size());
        for (String id : ids) {
            BooleanClause clause = new BooleanClause((Query)new TermQuery(new Term("entry_id", id)), BooleanClause.Occur.FILTER);
            BooleanQuery query = new BooleanQuery.Builder().add(clause).build();
            IndexSearcher indexSearcher = this.getGeneRecordIndexSearcher();
            TopDocs result = indexSearcher.search((Query)query, 1);
            if (result.totalHits.value <= 0L) continue;
            int docID = result.scoreDocs[0].doc;
            Document d = indexSearcher.doc(docID);
            GeneRecordHit m = this.getRecordHit(true, new GeneName("<retrieved by id " + id + ">", this.normalizer), result.scoreDocs[0], d);
            entries.add(m);
        }
        return entries;
    }

    public List<String> getSynonyms(String id) {
        try {
            List<String> ret = Collections.emptyList();
            BooleanClause clause = new BooleanClause((Query)new WildcardQuery(new Term("entry_id", id + "__*")), BooleanClause.Occur.FILTER);
            BooleanQuery query = new BooleanQuery.Builder().add(clause).build();
            int maxRet = 200;
            IndexSearcher indexSearcher = this.getNameCentricIndexSearcher();
            TopDocs result = indexSearcher.search((Query)query, maxRet);
            if (result.totalHits.value > 0L) {
                ret = new ArrayList<String>(maxRet);
                for (int i = 0; i < result.scoreDocs.length; ++i) {
                    Document doc = indexSearcher.doc(result.scoreDocs[i].doc);
                    String geneName = doc.getField("indexed_syn").stringValue();
                    ret.add(geneName);
                }
            }
            return ret;
        }
        catch (IOException e) {
            throw new GeneExpRuntimeException((Throwable)e);
        }
    }

    public List<SynHit> scoreIdsByNGramSynonyms(String synonymsString, Set<String> geneIds) {
        new CandidateCacheKey(new GeneName(synonymsString, this.normalizer));
        QueryBuilder qb = new QueryBuilder((Analyzer)this.ngramAnalyzer);
        Query ngramQuery = qb.createBooleanQuery("indexed_syn_ngrams", synonymsString);
        Stream<TermQuery> idTermQueries = geneIds.stream().map(id -> new TermQuery(new Term("entry_id", id)));
        BooleanQuery.Builder filterBuilder = new BooleanQuery.Builder();
        idTermQueries.forEach(q -> filterBuilder.add((Query)q, BooleanClause.Occur.SHOULD));
        if (qb != null) {
            BooleanQuery.Builder mainQb = new BooleanQuery.Builder().add(ngramQuery, BooleanClause.Occur.MUST).add((Query)filterBuilder.build(), BooleanClause.Occur.FILTER);
            ArrayList<SynHit> allHits = new ArrayList<SynHit>();
            try {
                IndexSearcher indexSearcher = this.getNameCentricIndexSearcher();
                TopDocs topdocs = indexSearcher.search((Query)mainQb.build(), 1000);
                for (ScoreDoc doc : topdocs.scoreDocs) {
                    Document d = indexSearcher.doc(doc.doc);
                    String indexNormalizedName = d.getField("indexed_syn").stringValue();
                    List ids = Collections.emptyList();
                    List taxIds = Collections.emptyList();
                    String source = null;
                    String entityType = null;
                    SynHit m = new SynHit(indexNormalizedName, (double)doc.score, ids, source, entityType, taxIds);
                    allHits.add(m);
                }
            }
            catch (IOException e) {
                throw new GeneExpRuntimeException((Throwable)e);
            }
            return allHits;
        }
        return Collections.emptyList();
    }

    @Override
    public List<SynHit> scoreIdsByBoWSynonyms(Collection<String> allSynonyms, Set<String> ids, QueryGenerator qg) {
        CandidateCacheKey cacheKey = new CandidateCacheKey(new GeneName(String.join((CharSequence)" ", allSynonyms), this.normalizer), null);
        cacheKey.setGeneIdsFilter(ids);
        cacheKey.setQueryGenerator(qg);
        cacheKey.setMaxHits(1000);
        cacheKey.setLoadSynHitFields(false);
        return this.getCandidatesFromIndex(cacheKey);
    }

    @Override
    public List<SynHit> getCandidates(GeneMention gm, Collection<String> taxId, Parameters parameters, QueryGenerator queryGenerator) {
        throw new NotImplementedException("This method should be implemented when needed.");
    }

    public Pair<Map<String, Double>, Map<String, List<String>>> scoreSynonymsRecordIndex(Collection<GeneName> allSynonyms, Set<String> ids, Function<GeneRecordHit, String[]> synhit2namesFunc, QueryGenerator qg) {
        HashMap<String, Double> scores = new HashMap<String, Double>();
        HashMap<String, List> ids2synonyms = new HashMap<String, List>();
        for (GeneName synonym : allSynonyms) {
            CandidateCacheKey cacheKey = new CandidateCacheKey(synonym, null);
            cacheKey.setGeneIdsFilter(ids);
            cacheKey.setQueryGenerator(qg);
            cacheKey.setMaxHits(1000);
            cacheKey.setLoadSynHitFields(synhit2namesFunc != null);
            for (SynHit sh : this.getCandidatesFromIndex(cacheKey)) {
                scores.merge(sh.getId(), sh.getLexicalScore(), (s1, s2) -> s1 + s2);
                if (synhit2namesFunc == null) continue;
                List names = ids2synonyms.compute(sh.getId(), (k, v) -> v != null ? v : new ArrayList());
                String[] newnames = synhit2namesFunc.apply((GeneRecordHit)sh);
                if (newnames == null) continue;
                for (String name : newnames) {
                    if (name == null) continue;
                    names.add(name);
                }
            }
        }
        return new ImmutablePair(scores, ids2synonyms);
    }

    public List<SynHit> scoreIdsByExactSynonyms(Collection<String> allSynonyms, Set<String> geneIds) {
        Stream<TermQuery> exactSynonymTermQueries = allSynonyms.stream().map(s -> new TermQuery(new Term("indexed_syn_exact", s)));
        Stream<TermQuery> idTermQueries = geneIds.stream().map(id -> new TermQuery(new Term("entry_id", id)));
        BooleanQuery.Builder qb = new BooleanQuery.Builder();
        exactSynonymTermQueries.forEach(q -> qb.add((Query)q, BooleanClause.Occur.SHOULD));
        BooleanQuery.Builder filterBuilder = new BooleanQuery.Builder();
        idTermQueries.forEach(q -> filterBuilder.add((Query)q, BooleanClause.Occur.SHOULD));
        BooleanQuery.Builder exactSynonymQuery = qb.add((Query)filterBuilder.build(), BooleanClause.Occur.FILTER);
        ArrayList<SynHit> allHits = new ArrayList<SynHit>();
        try {
            IndexSearcher indexSearcher = this.getNameCentricIndexSearcher();
            TopDocs topdocs = indexSearcher.search((Query)exactSynonymQuery.build(), 1000);
            for (ScoreDoc doc : topdocs.scoreDocs) {
                Document d = indexSearcher.doc(doc.doc);
                String indexNormalizedName = d.getField("indexed_syn").stringValue();
                List taxIds = Collections.emptyList();
                String source = null;
                String entityType = null;
                ArrayList ids = new ArrayList();
                Arrays.stream(d.getFields("entry_id")).map(IndexableField::stringValue).map(idAndSyn -> idAndSyn.split(NAME_PRIO_DELIMITER)).forEach(split -> ids.add(split[0]));
                SynHit m = new SynHit(indexNormalizedName, (double)doc.score, ids, source, entityType, taxIds);
                allHits.add(m);
            }
        }
        catch (IOException e) {
            throw new GeneExpRuntimeException((Throwable)e);
        }
        return allHits;
    }

    public List<String> getPriorityNames(String id, int priority) {
        try {
            List<String> ret = Collections.emptyList();
            BooleanClause ic = new BooleanClause((Query)new TermQuery(new Term("entry_id", id + NAME_PRIO_DELIMITER + priority)), BooleanClause.Occur.FILTER);
            BooleanQuery query = new BooleanQuery.Builder().add(ic).build();
            int maxRet = 1;
            IndexSearcher indexSearcher = this.getNameCentricIndexSearcher();
            TopDocs result = indexSearcher.search((Query)query, maxRet);
            if (result.totalHits.value > 0L) {
                ret = new ArrayList<String>(maxRet);
                for (int i = 0; i < result.scoreDocs.length; ++i) {
                    Document doc = indexSearcher.doc(result.scoreDocs[i].doc);
                    String name = doc.getField("indexed_syn").stringValue();
                    ret.add(name);
                }
            }
            return ret;
        }
        catch (IOException e) {
            throw new GeneExpRuntimeException((Throwable)e);
        }
    }

    public Map<String, String> getPriorityNamesMap(Collection<String> ids, int priority) {
        try {
            Map<String, String> ret = Collections.emptyMap();
            BooleanQuery.Builder qb = new BooleanQuery.Builder();
            ids.stream().map(id -> new TermQuery(new Term("entry_id", id + NAME_PRIO_DELIMITER + priority))).forEach(q -> qb.add((Query)q, BooleanClause.Occur.SHOULD));
            BooleanQuery query = new BooleanQuery.Builder().add((Query)qb.build(), BooleanClause.Occur.FILTER).build();
            IndexSearcher indexSearcher = this.getNameCentricIndexSearcher();
            TopDocs result = indexSearcher.search((Query)query, ids.size());
            if (result.totalHits.value > 0L) {
                ret = new HashMap<String, String>(ids.size());
                for (int i = 0; i < result.scoreDocs.length; ++i) {
                    Document doc = indexSearcher.doc(result.scoreDocs[i].doc);
                    String id2 = null;
                    id2 = Stream.of(doc.getFields("entry_id")).map(IndexableField::stringValue).map(x -> x.split(NAME_PRIO_DELIMITER)[0]).filter(x -> ids.contains(x)).findFirst().get();
                    String name = doc.getField("indexed_syn").stringValue();
                    ret.put(id2, name);
                }
            }
            return ret;
        }
        catch (IOException e) {
            throw new GeneExpRuntimeException((Throwable)e);
        }
    }

    public List<String> getPriorityNames(Collection<String> ids, int priority) throws IOException {
        Stream.Builder<List<String>> builder = Stream.builder();
        for (String id : ids) {
            builder.accept(this.getPriorityNames(id, priority));
        }
        return builder.build().flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Override
    public void close() {
        try {
            if (this.nameCentricIndexReader != null) {
                this.nameCentricIndexReader.close();
            }
            if (this.geneRecordIndexReader != null) {
                this.geneRecordIndexReader.close();
            }
        }
        catch (IOException e) {
            log.error("Could not close lucene indices", (Throwable)e);
        }
    }

    @Override
    public List<SynHit> getFamilyNames(GeneMention gm, QueryGenerator queryGenerator) {
        throw new NotImplementedException("This method should be implemented when needed.");
    }

    @Override
    public List<SynHit> getOriginalNamesIndexRecords(Collection<String> geneIds, GeneName geneName) {
        throw new NotImplementedException("This method should be implemented when needed.");
    }

    @Override
    public List<SynHit> getOriginalNamesIndexRecords(Collection<String> geneIds) {
        throw new NotImplementedException("This method should be implemented when needed.");
    }

    @Override
    public TFIDFScorer getTFIDFOnGeneRecordNames() {
        throw new NotImplementedException("This method should be implemented when needed.");
    }

    @Override
    public void setFulltextFieldsToRecordHits(Collection<? extends SynHit> recordHits, Collection<String> recordContextFieldNames) {
        throw new NotImplementedException("This method should be implemented when needed.");
    }

    @Override
    public Pair<Map<String, Double>, Map<String, Set<String>>> scoreSynonymsRecordIndex(String queryType, Map<String, Collection<GeneName>> ids2entities, Function<GeneRecordHit, String[]> synhit2namesFunc, QueryGenerator qg) {
        return null;
    }

    private IndexSearcher getGeneRecordIndexSearcher() {
        return geneRecordIndexSearcher.compute(Thread.currentThread(), (k, v) -> v != null ? v : new IndexSearcher(this.geneRecordIndexReader, (Executor)executorService));
    }

    private IndexSearcher getNameCentricIndexSearcher() {
        IndexSearcher indexSearcher = mentionIndexSearcher.compute(Thread.currentThread(), (k, v) -> v != null ? v : new IndexSearcher(this.nameCentricIndexReader, (Executor)executorService));
        indexSearcher.setSimilarity((Similarity)new ClassicSimilarity());
        return indexSearcher;
    }

    private List<SynHit> getCandidatesFromRecordIndex(CandidateCacheKey key) throws IOException {
        try {
            Query query = key.generateQuery();
            TopScoreDocCollector resultsCollector = TopScoreDocCollector.create((int)key.getMaxHits(), (int)key.getMaxHits());
            IndexSearcher indexSearcher = this.getGeneRecordIndexSearcher();
            indexSearcher.search(query, (Collector)resultsCollector);
            TopDocs topDocs = resultsCollector.topDocs();
            ArrayList<SynHit> ret = new ArrayList<SynHit>();
            boolean loadSynHitFields = key.isLoadSynHitFields();
            GeneName geneName = key.getGeneName();
            for (ScoreDoc doc : topDocs.scoreDocs) {
                Document document = indexSearcher.doc(doc.doc);
                GeneRecordHit sh = this.getRecordHit(loadSynHitFields, geneName, doc, document);
                ret.add(sh);
            }
            return ret;
        }
        catch (BooleanQuery.TooManyClauses e) {
            log.warn("Got too many clauses exception from gene name \"{}\". Assuming that this is a tagging error and not returning any candidates.", (Object)key.getGeneName().getText());
            return Collections.emptyList();
        }
    }

    @NotNull
    private GeneRecordHit getRecordHit(boolean loadSynHitFields, GeneName geneName, ScoreDoc doc, Document document) {
        IndexableField symbolField;
        String id = document.getField("entry_id").stringValue();
        String taxId = null;
        if (loadSynHitFields) {
            taxId = document.getField("tax_id").stringValue();
        }
        String symbol = (symbolField = document.getField("symbol")) != null ? symbolField.stringValue() : "";
        GeneRecordHit sh = new GeneRecordHit(symbol, doc.score, id, "<no source specified>");
        sh.setMappedMention(geneName != null ? geneName.getText() : "none");
        sh.setLuceneScore(doc.score);
        if (taxId != null) {
            sh.setTaxIds(Collections.singletonList(taxId));
            sh.setTaxId(taxId);
        }
        if (loadSynHitFields) {
            sh.setSymbol(symbol);
            Optional.ofNullable(document.getField("symbol_from_nomenclature")).ifPresent(f -> sh.setNomenclature(f.stringValue()));
            Optional.ofNullable(document.getField("chromosome")).ifPresent(f -> sh.setChromosome(f.stringValue()));
            Optional.ofNullable(document.getField("maplocation")).ifPresent(f -> sh.setMapLocation(f.stringValue()));
            sh.setSynonyms((String[])Arrays.stream(document.getFields("synonyms")).map(IndexableField::stringValue).toArray(String[]::new));
            sh.setFullNames((String[])Arrays.stream(document.getFields("full_names")).map(IndexableField::stringValue).toArray(String[]::new));
            sh.setOtherDesignations((String[])Arrays.stream(document.getFields("other_designations")).map(IndexableField::stringValue).toArray(String[]::new));
            sh.setXrefs((String[])Arrays.stream(document.getFields("xrefs")).map(IndexableField::stringValue).toArray(String[]::new));
            sh.setUniprotNames((String[])Arrays.stream(document.getFields("uniprot_names")).map(IndexableField::stringValue).toArray(String[]::new));
            sh.setBioThesaurusNames((String[])Arrays.stream(document.getFields("bio_thesaurus")).map(IndexableField::stringValue).toArray(String[]::new));
            for (String synonymField : GeneRecordQueryGenerator.SYNONYM_FIELDS) {
                Optional<String> anyExactMatch = Arrays.stream(document.getFields(synonymField)).map(IndexableField::stringValue).filter(f -> f.equals(geneName.getNormalizedText())).findAny();
                if (!anyExactMatch.isPresent()) continue;
                sh.setLexicalScore(9999.0);
                sh.setSynonym(anyExactMatch.get());
            }
        }
        return sh;
    }

    public Set<GeneRecordHit> getGeneRecords(Collection<String> ids) {
        try {
            HashSet<GeneRecordHit> hits = new HashSet<GeneRecordHit>();
            IndexSearcher indexSearcher = this.getGeneRecordIndexSearcher();
            BooleanQuery.Builder mainBuilder = new BooleanQuery.Builder();
            mainBuilder.add((Query)new MatchAllDocsQuery(), BooleanClause.Occur.MUST);
            BooleanQuery.Builder filterBuilder = new BooleanQuery.Builder();
            ids.stream().forEach(id -> filterBuilder.add((Query)new TermQuery(new Term("entry_id", id)), BooleanClause.Occur.SHOULD));
            mainBuilder.add((Query)filterBuilder.build(), BooleanClause.Occur.FILTER);
            TopDocs topdocs = indexSearcher.search((Query)mainBuilder.build(), ids.size());
            for (ScoreDoc sd : topdocs.scoreDocs) {
                Document doc = indexSearcher.doc(sd.doc);
                GeneRecordHit recordHit = this.getRecordHit(true, null, sd, doc);
                hits.add(recordHit);
            }
            return hits;
        }
        catch (IOException e) {
            throw new GeneExpRuntimeException((Throwable)e);
        }
    }

    private Map<String, Float> getFieldWeightsFromParameters(Map<String, Object> parameterMap) {
        if (parameterMap == null) {
            parameterMap = Collections.emptyMap();
        }
        HashMap<String, Float> fieldWeights = new HashMap<String, Float>();
        Object tieBreaker = parameterMap.get(Configuration.dot((String[])new String[]{"candidate_retrieval", "dismax_tie_breaker"}));
        tieBreaker = tieBreaker == null ? this.globalFieldWeights.getOrDefault("dismax_tie_breaker", Float.valueOf(0.3f)) : Float.valueOf(Float.parseFloat((String)tieBreaker));
        fieldWeights.put("dismax_tie_breaker", (Float)tieBreaker);
        for (String field : GeneRecordQueryGenerator.ALL_FIELDS) {
            Float defaultValue = this.globalFieldWeights.getOrDefault(field, Float.valueOf(1.0f));
            String parameterValue = (String)parameterMap.get(Configuration.dot((String[])new String[]{"candidate_retrieval", field}));
            float finalValue = parameterValue != null ? Float.parseFloat(parameterValue) : defaultValue.floatValue();
            fieldWeights.put(field, Float.valueOf(finalValue));
        }
        for (String field : GeneRecordQueryGenerator.SYNONYM_FIELDS) {
            String exactFieldName = field + "_exact";
            Float defaultValue = this.globalFieldWeights.getOrDefault(exactFieldName, Float.valueOf(1.0f));
            String parameterValue = (String)parameterMap.get(Configuration.dot((String[])new String[]{"candidate_retrieval", exactFieldName}));
            float finalValue = parameterValue != null ? Float.parseFloat(parameterValue) : defaultValue.floatValue();
            fieldWeights.put(exactFieldName, Float.valueOf(finalValue));
        }
        return fieldWeights;
    }
}

