/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.consumer.bionlpformat.main;

import de.julielab.jcore.consumer.bionlpformat.main.BioEventConsumer;
import de.julielab.jcore.consumer.bionlpformat.utils.DocumentWriter;
import de.julielab.jcore.consumer.bionlpformat.utils.EntityWriter;
import de.julielab.jcore.consumer.bionlpformat.utils.EventMentionWriter;
import de.julielab.jcore.consumer.bionlpformat.utils.MedEventWriter;
import de.julielab.jcore.types.EntityMention;
import de.julielab.jcore.types.pubmed.Header;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.CASRuntimeException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.Type;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MedEventConsumer
extends JCasAnnotator_ImplBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(BioEventConsumer.class);
    public static final String DIRECTORY_PARAM = "outDirectory";
    @ConfigurationParameter(name="outDirectory", mandatory=true)
    private File directory;
    int id = 1;

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        String directoryName = (String)aContext.getConfigParameterValue(DIRECTORY_PARAM);
        this.directory = new File(directoryName);
        if (!this.directory.exists()) {
            this.directory.mkdir();
        }
    }

    public void process(JCas aJCas) throws AnalysisEngineProcessException {
        CAS cas = aJCas.getCas();
        String id = this.getDocumentId(cas);
        String documentText = cas.getDocumentText();
        Type entityType = cas.getTypeSystem().getType(EntityMention.class.getCanonicalName());
        try {
            DocumentWriter documentWriter = this.createDocumentWriter(id);
            MedEventWriter eventWriter = this.createEventWriter(documentText, id);
            documentWriter.write(cas.getJCas());
            for (EntityMention entityMention : cas.getAnnotationIndex(entityType)) {
                eventWriter.writeEvent(entityMention);
            }
            documentWriter.close();
            eventWriter.close();
        }
        catch (IOException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        catch (CASException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }

    private MedEventWriter createEventWriter(String documentText, String id) throws AnalysisEngineProcessException {
        BufferedWriter annotationFileWriter = null;
        EntityWriter medicationWriter = null;
        EventMentionWriter attributeWriter = null;
        try {
            annotationFileWriter = new BufferedWriter(new FileWriter(new File(this.directory, id + ".ann")));
            medicationWriter = new EntityWriter(annotationFileWriter, documentText);
            attributeWriter = new EventMentionWriter(annotationFileWriter, documentText);
            return new MedEventWriter(annotationFileWriter, medicationWriter, attributeWriter);
        }
        catch (IOException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }

    private DocumentWriter createDocumentWriter(String id) throws IOException {
        return new DocumentWriter(new BufferedWriter(new FileWriter(new File(this.directory, id + ".txt"))));
    }

    private String getDocumentId(CAS cas) {
        Header header = null;
        try {
            FSIterator iterator = cas.getJCas().getAnnotationIndex(Header.type).iterator();
            header = (Header)iterator.next();
        }
        catch (CASRuntimeException e) {
            e.printStackTrace();
        }
        catch (CASException e) {
            e.printStackTrace();
        }
        if (header != null) {
            return header.getDocId();
        }
        return new Integer(this.id++).toString();
    }
}

