/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.consumer.bionlpformat.main;

import de.julielab.jcore.consumer.bionlpformat.main.BioEventConsumer;
import de.julielab.jcore.consumer.bionlpformat.utils.DocumentWriter;
import de.julielab.jcore.consumer.bionlpformat.utils.SegmentWriter;
import de.julielab.jcore.types.Sentence;
import de.julielab.jcore.types.pubmed.Header;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.CASRuntimeException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.Type;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentConsumer
extends JCasAnnotator_ImplBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(BioEventConsumer.class);
    public static final String DIRECTORY_PARAM = "outDirectory";
    @ConfigurationParameter(name="outDirectory", mandatory=true)
    private File directory;
    int id = 1;

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        String directoryName = (String)aContext.getConfigParameterValue(DIRECTORY_PARAM);
        this.directory = new File(directoryName);
        if (!this.directory.exists()) {
            this.directory.mkdir();
        }
    }

    public void process(JCas aJCas) throws AnalysisEngineProcessException {
        CAS cas = aJCas.getCas();
        String id = this.getDocumentId(cas);
        String documentText = cas.getDocumentText();
        Type sentenceType = cas.getTypeSystem().getType(Sentence.class.getCanonicalName());
        try {
            DocumentWriter documentWriter = this.createDocumentWriter(id);
            SegmentWriter segmentWriter = this.createSegmentWriter(documentText, id);
            documentWriter.write(cas.getJCas());
            FSIterator sentenceIterator = cas.getAnnotationIndex(sentenceType).iterator();
            if (!sentenceIterator.hasNext()) {
                segmentWriter.writeTokensOnly(cas);
            } else {
                while (sentenceIterator.hasNext()) {
                    Sentence sentence = (Sentence)sentenceIterator.next();
                    segmentWriter.writeSentence(sentence);
                }
            }
            documentWriter.close();
            segmentWriter.close();
        }
        catch (IOException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        catch (CASException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }

    private DocumentWriter createDocumentWriter(String id) throws IOException {
        return new DocumentWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(this.directory, id + ".txt")), "UTF-8")));
    }

    private SegmentWriter createSegmentWriter(String documentText, String id) throws AnalysisEngineProcessException {
        BufferedWriter annotationFileWriter = null;
        try {
            annotationFileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(this.directory, id + ".ann")), "UTF-8"));
            return new SegmentWriter(annotationFileWriter, documentText);
        }
        catch (IOException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }

    private String getDocumentId(CAS cas) {
        Header header = null;
        try {
            FSIterator iterator = cas.getJCas().getAnnotationIndex(Header.type).iterator();
            header = (Header)iterator.next();
        }
        catch (CASRuntimeException e) {
            e.printStackTrace();
        }
        catch (CASException e) {
            e.printStackTrace();
        }
        if (header != null) {
            return header.getDocId();
        }
        return new Integer(this.id++).toString();
    }
}

