/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.consumer.bionlpformat.utils;

import de.julielab.jcore.consumer.bionlpformat.utils.EntityWriter;
import de.julielab.jcore.consumer.bionlpformat.utils.EventMentionWriter;
import de.julielab.jcore.types.EntityMention;
import de.julielab.jcore.types.medical.Medication;
import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;

public class MedEventWriter {
    private static final String MEDICATION_TYPE = "DRUG";
    private Writer writer;
    private EntityWriter medicationWriter;
    private EventMentionWriter attributesWriter;
    private Set<String> writtenIds;

    public Writer getFileWriter() {
        return this.writer;
    }

    public void setFileWriter(Writer writer) {
        this.writer = writer;
    }

    public MedEventWriter(Writer writer, EntityWriter medicationWriter, EventMentionWriter attributeWriter) {
        this.writer = writer;
        this.medicationWriter = medicationWriter;
        this.attributesWriter = attributeWriter;
        this.writtenIds = new HashSet<String>();
    }

    public void writeEvent(EntityMention entity) {
        if (null == entity) {
            throw new IllegalArgumentException("null reference has been passed instead on an EventMention instance.");
        }
        String id = entity.getId();
        if (this.writtenIds.contains(id)) {
            System.out.println("ERROR! Event already written " + entity.getId() + " " + entity.getCoveredText());
            return;
        }
        this.writtenIds.add(id);
        if (entity.getSpecificType().equals(MEDICATION_TYPE)) {
            Medication med = (Medication)entity;
            try {
                this.medicationWriter.writeEntity((EntityMention)med);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.attributesWriter.writeEvent(med);
        }
    }

    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.close();
        }
        if (this.medicationWriter != null) {
            this.medicationWriter.close();
        }
        if (this.attributesWriter != null) {
            this.attributesWriter.close();
        }
    }
}

