/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.consumer.cas2conll;

import de.julielab.jcore.consumer.cas2conll.IOUtils;
import de.julielab.jcore.types.DependencyRelation;
import de.julielab.jcore.types.Header;
import de.julielab.jcore.types.Sentence;
import de.julielab.jcore.types.Token;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.CASRuntimeException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JFSIndexRepository;
import org.apache.uima.resource.ResourceInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConllConsumer
extends JCasAnnotator_ImplBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConllConsumer.class);
    public static final String PARAM_OUTPUT_DIR = "outputDir";
    public static final String PARAM_DEPENDENCY_PARSE = "dependencyParse";
    private static final Boolean DEFAULT_DEPENDENCY_PARSE = false;
    @ConfigurationParameter(name="outputDir", mandatory=true)
    private String outputDir;
    @ConfigurationParameter(name="dependencyParse", mandatory=false)
    private Boolean dependencyParse;
    int docs = 0;

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        LOGGER.info("INITIALIZING CONLL Consumer ...");
        this.outputDir = (String)aContext.getConfigParameterValue(PARAM_OUTPUT_DIR);
        if (!this.outputDir.endsWith("/")) {
            this.outputDir = this.outputDir + "/";
        }
        this.dependencyParse = aContext.getConfigParameterValue(PARAM_DEPENDENCY_PARSE) != null ? (Boolean)aContext.getConfigParameterValue(PARAM_DEPENDENCY_PARSE) : DEFAULT_DEPENDENCY_PARSE;
    }

    public void process(JCas aJCas) throws AnalysisEngineProcessException {
        LOGGER.info("Processing next document ... ");
        try {
            FSIterator sentenceIterator = aJCas.getAnnotationIndex(Sentence.type).iterator();
            AnnotationIndex tokenIndex = aJCas.getAnnotationIndex(Token.type);
            ArrayList<String> sentences = new ArrayList<String>();
            while (sentenceIterator.hasNext()) {
                Sentence sentence = (Sentence)sentenceIterator.next();
                FSIterator tokIterator = tokenIndex.subiterator((AnnotationFS)sentence);
                ArrayList<Token> toks2convert = new ArrayList<Token>();
                while (tokIterator.hasNext()) {
                    Token rel = (Token)tokIterator.next();
                    toks2convert.add(rel);
                }
                String sentenceCONLL = "";
                for (int i = 0; i < toks2convert.size(); ++i) {
                    Token token = (Token)toks2convert.get(i);
                    Token head = null;
                    String depLabel = "ROOT";
                    Object pos = null;
                    int headNumber = 0;
                    if (token.getDepRel() == null) {
                        if (this.dependencyParse.booleanValue()) {
                            LOGGER.error("Token without dependency relation occured " + token.getCoveredText());
                        }
                        headNumber = 0;
                        depLabel = "_";
                    } else {
                        DependencyRelation depRel = token.getDepRel(0);
                        if (depRel != null) {
                            head = depRel.getHead();
                            headNumber = toks2convert.indexOf(head) + 1;
                        }
                        if (head != null) {
                            depLabel = depRel.getLabel();
                        }
                    }
                    String line = i + 1 + "\t" + token.getCoveredText() + "\t" + token.getCoveredText() + "\t" + token.getPosTag(0).getValue() + "\t" + token.getPosTag(0).getValue() + "\t" + "_" + "\t" + "_" + "\t" + "_" + "\t" + headNumber + "\t" + depLabel + "\t" + "_" + "\t" + "_" + "\n";
                    sentenceCONLL = sentenceCONLL + line;
                }
                sentences.add(sentenceCONLL);
            }
            String fileId = this.getDocID(aJCas);
            if (fileId == null || fileId.isEmpty()) {
                fileId = new Integer(this.docs++).toString();
            }
            this.writeSentences2File(fileId, sentences);
        }
        catch (CASRuntimeException e) {
            e.printStackTrace();
        }
        catch (CASException e) {
            e.printStackTrace();
        }
    }

    public String getDocID(JCas aJCas) throws CASException {
        String docID = "";
        JFSIndexRepository indexes = aJCas.getJFSIndexRepository();
        for (Header h : indexes.getAnnotationIndex(Header.type)) {
            docID = h.getDocId();
        }
        return docID;
    }

    private void writeSentences2File(String fileId, ArrayList<String> sentences) {
        try {
            new File(this.outputDir).mkdirs();
            IOUtils.arraylist_to_file(sentences, new File(this.outputDir + fileId + ".CONLL"));
            LOGGER.info("wrote file " + this.outputDir + fileId + ".CONLL");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

