/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.consumer.cas2conll;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;

public class IOUtils {
    public static ArrayList<String> file_to_arraylist(File file) throws IOException {
        ArrayList<String> output = new ArrayList<String>();
        BufferedReader fr = new BufferedReader(new FileReader(file));
        String line = fr.readLine();
        while (line != null) {
            output.add(line);
            line = fr.readLine();
        }
        return output;
    }

    public static void arraylist_to_file(ArrayList array, File file) throws IOException {
        FileWriter fw = new FileWriter(file);
        for (String element : array) {
            if (element == null || element == "") continue;
            fw.write(element + "\n");
        }
        fw.close();
    }

    public static void hashmapKeys_to_file(HashMap array, File file) throws IOException {
        FileWriter fw = new FileWriter(file);
        Set keys = array.keySet();
        for (String word : keys) {
            fw.write(word + "\n");
        }
        fw.close();
    }

    public static HashMap file_to_hashmapKeys(File file) throws IOException {
        HashMap<String, String> output = new HashMap<String, String>();
        BufferedReader fr = new BufferedReader(new FileReader(file));
        String line = fr.readLine();
        while (line != null) {
            output.put(line, line);
            line = fr.readLine();
        }
        return output;
    }

    public static AnnotationFS findCoverFS(CAS aCAS, AnnotationFS annot, Type coverFsType) {
        AnnotationFS coverFs = null;
        AnnotationFS searchFs = aCAS.createAnnotation(coverFsType, annot.getBegin(), aCAS.getDocumentText().length());
        FSIterator iterator = aCAS.getAnnotationIndex(coverFsType).iterator();
        iterator.moveTo((FeatureStructure)searchFs);
        if (iterator.isValid()) {
            coverFs = (AnnotationFS)iterator.get();
            if (coverFs.getBegin() <= annot.getBegin() && coverFs.getEnd() >= annot.getEnd()) {
                return coverFs;
            }
            iterator.moveToPrevious();
            if (iterator.isValid() && (coverFs = (AnnotationFS)iterator.get()).getBegin() <= annot.getBegin() && coverFs.getEnd() >= annot.getEnd()) {
                return coverFs;
            }
        } else {
            iterator.moveToLast();
            if (iterator.isValid() && (coverFs = (AnnotationFS)iterator.get()).getBegin() <= annot.getBegin() && coverFs.getEnd() >= annot.getEnd()) {
                return coverFs;
            }
        }
        return null;
    }
}

