/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.ae.jnet.uima;

import com.google.common.collect.HashMultimap;
import de.julielab.jcore.types.Abbreviation;
import de.julielab.jcore.types.AbbreviationLongform;
import de.julielab.jcore.types.EntityMention;
import de.julielab.jcore.types.Token;
import de.julielab.jcore.utility.JCoReAnnotationTools;
import de.julielab.jcore.utility.index.Comparators;
import de.julielab.jcore.utility.index.JCoReHashMapAnnotationIndex;
import de.julielab.jcore.utility.index.JCoReMapAnnotationIndex;
import de.julielab.jcore.utility.index.JCoReSetAnnotationIndex;
import de.julielab.jcore.utility.index.TermGenerators;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsistencyPreservation {
    private static final String COMPONENT_ID = "JNET ConsistencyPreservation";
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsistencyPreservation.class);
    public static final String MODE_ACRO2FULL = "acro2full";
    public static final String MODE_FULL2ACRO = "full2acro";
    public static final String MODE_STRING = "string";
    public static final String MODE_STRING_TOKEN_BOUNDARIES = "stringTokenBoundaries";
    private TreeSet<String> activeModes = new TreeSet();

    public ConsistencyPreservation(String modesString) throws ResourceInitializationException {
        String[] modes;
        for (String mode2 : modes = modesString.split(",")) {
            String mode = mode2.trim();
            if (!(mode.equals(MODE_ACRO2FULL) || mode.equals(MODE_FULL2ACRO) || mode.equals(MODE_STRING) || mode.equals(MODE_STRING_TOKEN_BOUNDARIES))) {
                LOGGER.error("ConsistencyPreservation() - unknown mode found!");
                throw new ResourceInitializationException();
            }
            this.activeModes.add(mode);
        }
        LOGGER.info("ConsistencyPreservation() - modes used in consistency engine: " + this.activeModes.toString());
    }

    public void acroMatch(JCas aJCas, Set<String> entityMentionClassnames) throws AnalysisEngineProcessException {
        if (this.activeModes == null || this.activeModes.size() == 0 || !this.activeModes.contains(MODE_FULL2ACRO) && !this.activeModes.contains(MODE_ACRO2FULL)) {
            return;
        }
        Comparator<Annotation> comparator = new Comparator<Annotation>(){

            @Override
            public int compare(Annotation o1, Annotation o2) {
                if (o1.getBegin() == o2.getBegin() && o1.getEnd() == o2.getEnd()) {
                    return 0;
                }
                if (o1.getBegin() - o2.getBegin() == 0) {
                    return o1.getEnd() - o2.getEnd();
                }
                return o1.getBegin() - o2.getBegin();
            }
        };
        TreeSet<Annotation> acronyms = new TreeSet<Annotation>(comparator);
        TreeSet<Annotation> fullforms = new TreeSet<Annotation>(comparator);
        TreeSet<Annotation> entities = new TreeSet<Annotation>(comparator);
        for (Abbreviation abbreviation : aJCas.getAnnotationIndex(Abbreviation.type)) {
            acronyms.add((Annotation)abbreviation);
            fullforms.add((Annotation)abbreviation.getTextReference());
        }
        for (String entityMentionClassName : entityMentionClassnames) {
            Type entityType = aJCas.getTypeSystem().getType(entityMentionClassName);
            FSIterator it = aJCas.getAnnotationIndex(entityType).iterator();
            while (it.hasNext()) {
                entities.add((Annotation)it.next());
            }
        }
        for (Abbreviation abbreviation : aJCas.getAnnotationIndex(Abbreviation.type)) {
            EntityMention newEntityMention;
            EntityMention refEntityMention;
            AbbreviationLongform fullform = abbreviation.getTextReference();
            EntityMention abbreviationEntityMention = (EntityMention)entities.floor((Annotation)abbreviation);
            EntityMention fullFormEntityMention = (EntityMention)entities.floor((Annotation)fullform);
            abbreviationEntityMention = abbreviationEntityMention != null && comparator.compare((Annotation)abbreviationEntityMention, (Annotation)abbreviation) == 0 ? abbreviationEntityMention : null;
            EntityMention entityMention = fullFormEntityMention = fullFormEntityMention != null && comparator.compare((Annotation)fullFormEntityMention, (Annotation)fullform) == 0 ? fullFormEntityMention : null;
            if (this.activeModes.contains(MODE_FULL2ACRO) && abbreviationEntityMention == null && fullFormEntityMention != null) {
                refEntityMention = fullFormEntityMention;
                try {
                    newEntityMention = (EntityMention)JCoReAnnotationTools.getAnnotationByClassName((JCas)aJCas, (String)refEntityMention.getClass().getName());
                    newEntityMention.setBegin(abbreviation.getBegin());
                    newEntityMention.setEnd(abbreviation.getEnd());
                    newEntityMention.setSpecificType(refEntityMention.getSpecificType());
                    newEntityMention.setResourceEntryList(refEntityMention.getResourceEntryList());
                    newEntityMention.setConfidence(refEntityMention.getConfidence());
                    newEntityMention.setComponentId("JNET ConsistencyPreservation Abbrev");
                    newEntityMention.addToIndexes();
                }
                catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    throw new AnalysisEngineProcessException((Throwable)e);
                }
            }
            if (!this.activeModes.contains(MODE_ACRO2FULL) || fullFormEntityMention != null || abbreviationEntityMention == null) continue;
            refEntityMention = abbreviationEntityMention;
            try {
                newEntityMention = (EntityMention)JCoReAnnotationTools.getAnnotationByClassName((JCas)aJCas, (String)refEntityMention.getClass().getName());
                newEntityMention.setBegin(fullform.getBegin());
                newEntityMention.setEnd(fullform.getEnd());
                newEntityMention.setSpecificType(refEntityMention.getSpecificType());
                newEntityMention.setResourceEntryList(refEntityMention.getResourceEntryList());
                newEntityMention.setConfidence(refEntityMention.getConfidence());
                newEntityMention.setComponentId("JNET ConsistencyPreservation Abbrev");
                newEntityMention.addToIndexes();
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
        }
    }

    public void stringMatch(JCas aJCas, TreeSet<String> entityMentionClassnames, double confidenceThresholdForConsistencyPreservation) throws AnalysisEngineProcessException {
        if (this.activeModes == null || this.activeModes.size() == 0 || !this.activeModes.contains(MODE_STRING) && !this.activeModes.contains(MODE_STRING_TOKEN_BOUNDARIES)) {
            return;
        }
        if (this.activeModes.contains(MODE_STRING_TOKEN_BOUNDARIES)) {
            this.stringMatchTokenBoundaries(aJCas, entityMentionClassnames);
            return;
        }
        String text = aJCas.getDocumentText();
        TypeSystem ts = aJCas.getTypeSystem();
        HashMap<String, JCoReSetAnnotationIndex> overlapIndex = new HashMap<String, JCoReSetAnnotationIndex>();
        JCoReSetAnnotationIndex tokenIndex = new JCoReSetAnnotationIndex(Comparators.overlapComparator(), aJCas, Token.type);
        for (String entityMentionClassname : entityMentionClassnames) {
            overlapIndex.clear();
            try {
                EntityMention mentionForOffsetComparison = (EntityMention)JCoReAnnotationTools.getAnnotationByClassName((JCas)aJCas, (String)entityMentionClassname);
                LOGGER.debug("doStringBased() - checking consistency for type: " + entityMentionClassname);
                HashMultimap entityMap = HashMultimap.create();
                Type entityType = ts.getType(entityMentionClassname);
                if (null == entityType) {
                    throw new IllegalArgumentException("Entity type \"" + entityMentionClassname + "\" was not found in the type system.");
                }
                LOGGER.debug("doStringBased() - building entity map");
                for (EntityMention entity : aJCas.getAnnotationIndex(entityType)) {
                    JCoReSetAnnotationIndex set;
                    entityMap.put((Object)entity.getCoveredText(), (Object)entity);
                    String specificType = "<null>";
                    if (!StringUtils.isBlank((CharSequence)entity.getSpecificType())) {
                        specificType = entity.getSpecificType();
                    }
                    if (null == (set = (JCoReSetAnnotationIndex)overlapIndex.get(specificType))) {
                        set = new JCoReSetAnnotationIndex(Comparators.overlapComparator());
                        overlapIndex.put(specificType, set);
                    }
                    set.add((Annotation)entity);
                }
                LOGGER.debug("doStringBased() - searching for missed entities...");
                for (String entityString : entityMap.keySet()) {
                    EntityMention entity = (EntityMention)entityMap.get((Object)entityString).iterator().next();
                    String specificType = "<null>";
                    if (!StringUtils.isBlank((CharSequence)entity.getSpecificType())) {
                        specificType = entity.getSpecificType();
                    }
                    JCoReSetAnnotationIndex overlapSet = (JCoReSetAnnotationIndex)overlapIndex.get(specificType);
                    LOGGER.debug("doStringBased() - checking entity string: " + entityString);
                    int pos = 0;
                    int length = 0;
                    ArrayList<EntityMention> stringMatchedEntities = new ArrayList<EntityMention>();
                    while ((pos = text.indexOf(entityString, pos + length)) > -1) {
                        LOGGER.debug("doStringBased() - found string at pos: " + pos);
                        length = entityString.length();
                        mentionForOffsetComparison.setBegin(pos);
                        mentionForOffsetComparison.setEnd(pos + length);
                        boolean overlappingExists = overlapSet.contains((Annotation)mentionForOffsetComparison);
                        if (!overlappingExists) {
                            Annotation lastToken;
                            LOGGER.debug("doStringBased() - adding annotation to unlabeled entity mention");
                            EntityMention refEntity = (EntityMention)JCoReAnnotationTools.getAnnotationByClassName((JCas)aJCas, (String)entityMentionClassname);
                            NavigableSet overlappingTokens = tokenIndex.searchSubset((Annotation)mentionForOffsetComparison);
                            Annotation firstToken = overlappingTokens.isEmpty() ? null : (Annotation)overlappingTokens.first();
                            Annotation annotation = lastToken = overlappingTokens.isEmpty() ? null : (Annotation)overlappingTokens.last();
                            if (this.activeModes.contains(MODE_STRING_TOKEN_BOUNDARIES) && (firstToken == null || pos != firstToken.getBegin() || pos + length != lastToken.getEnd())) continue;
                            int begin = overlappingTokens.size() > 0 ? ((Annotation)overlappingTokens.first()).getBegin() : pos;
                            int end = overlappingTokens.size() > 0 ? ((Annotation)overlappingTokens.last()).getEnd() : pos + entityString.length();
                            refEntity.setBegin(begin);
                            refEntity.setEnd(end);
                            refEntity.setSpecificType(entity.getSpecificType());
                            refEntity.setResourceEntryList(entity.getResourceEntryList());
                            refEntity.setConfidence(entity.getConfidence());
                            refEntity.setTextualRepresentation(entity.getTextualRepresentation());
                            refEntity.setComponentId("JNET ConsistencyPreservation String (" + entity.getCoveredText() + ", " + begin + "-" + end + ")");
                            stringMatchedEntities.add(refEntity);
                        } else {
                            LOGGER.debug("doStringBased() - there is already an entity!");
                        }
                        length = entityString.length();
                    }
                    if (confidenceThresholdForConsistencyPreservation > 0.0) {
                        if (stringMatchedEntities.isEmpty()) continue;
                        double meanConfidence = 0.0;
                        for (EntityMention recognizedEntity : entityMap.get((Object)entityString)) {
                            if (null == entity.getConfidence()) continue;
                            meanConfidence += Double.parseDouble(recognizedEntity.getConfidence());
                        }
                        meanConfidence /= (double)entityMap.get((Object)entityString).size();
                        int allMatches = stringMatchedEntities.size() + entityMap.get((Object)entityString).size();
                        if (!((double)entityMap.get((Object)entityString).size() >= (double)allMatches / 3.0) || !(meanConfidence > confidenceThresholdForConsistencyPreservation)) continue;
                        for (EntityMention refEntity : stringMatchedEntities) {
                            overlapSet.add((Annotation)refEntity);
                            refEntity.addToIndexes();
                        }
                        continue;
                    }
                    for (EntityMention refEntity : stringMatchedEntities) {
                        overlapSet.add((Annotation)refEntity);
                        refEntity.addToIndexes();
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("doStringBased() - exception occured: " + e.getMessage());
                throw new AnalysisEngineProcessException((Throwable)e);
            }
        }
    }

    private void stringMatchTokenBoundaries(JCas aJCas, TreeSet<String> entityMentionClassnames) {
        Set entityTypes = entityMentionClassnames.stream().map(name -> aJCas.getTypeSystem().getType(name)).collect(Collectors.toSet());
        JCoReHashMapAnnotationIndex tokenPrefixIndex = new JCoReHashMapAnnotationIndex(TermGenerators.edgeNGramTermGenerator((int)3), TermGenerators.prefixTermGenerator((int)3), aJCas, Token.type);
        JCoReHashMapAnnotationIndex tokenEndIndex = new JCoReHashMapAnnotationIndex(a -> a.getEnd(), a -> a.getEnd(), aJCas, Token.type);
        HashMap<String, JCoReSetAnnotationIndex> indexMap = new HashMap<String, JCoReSetAnnotationIndex>();
        for (Type t : entityTypes) {
            JCoReSetAnnotationIndex specificIndex;
            indexMap.clear();
            for (EntityMention em : aJCas.getAnnotationIndex(t)) {
                String specificType = em.getSpecificType();
                specificIndex = (JCoReSetAnnotationIndex)indexMap.get(specificType);
                if (null == specificIndex) {
                    specificIndex = new JCoReSetAnnotationIndex(Comparators.overlapComparator());
                    indexMap.put(specificType, specificIndex);
                }
                specificIndex.add((Annotation)em);
            }
            for (String specificType : indexMap.keySet()) {
                HashSet processedEntityNames = new HashSet();
                specificIndex = (JCoReSetAnnotationIndex)indexMap.get(specificType);
                new ArrayList(specificIndex.getIndex()).stream().forEach(arg_0 -> ConsistencyPreservation.lambda$stringMatchTokenBoundaries$8(processedEntityNames, (JCoReMapAnnotationIndex)tokenPrefixIndex, specificIndex, tokenEndIndex, aJCas, t, arg_0));
            }
        }
    }

    public String toString() {
        return "activeModes: " + this.activeModes;
    }

    private static /* synthetic */ void lambda$stringMatchTokenBoundaries$8(Set processedEntityNames, JCoReMapAnnotationIndex tokenPrefixIndex, JCoReSetAnnotationIndex specificIndex, JCoReHashMapAnnotationIndex tokenEndIndex, JCas aJCas, Type t, EntityMention entity) {
        String entityName = entity.getCoveredText();
        if (!processedEntityNames.add(entityName)) {
            return;
        }
        tokenPrefixIndex.search((Annotation)entity).filter(token -> token.getEnd() - token.getBegin() <= entityName.length() && entityName.startsWith(token.getCoveredText()) && !specificIndex.contains((Annotation)token)).map(token -> {
            int begin = token.getBegin();
            int end = -1;
            if (token.getEnd() == begin + entityName.length()) {
                end = token.getEnd();
            } else {
                Token lastToken = (Token)tokenEndIndex.get((Comparable)Integer.valueOf(begin + entityName.length()));
                if (lastToken != null) {
                    end = lastToken.getEnd();
                }
            }
            if (end >= 0 && aJCas.getDocumentText().substring(begin, end).equals(entityName)) {
                EntityMention refEntity = (EntityMention)aJCas.getCas().createAnnotation(t, begin, end);
                refEntity.setBegin(begin);
                refEntity.setEnd(end);
                refEntity.setSpecificType(entity.getSpecificType());
                refEntity.setResourceEntryList(entity.getResourceEntryList());
                refEntity.setConfidence(entity.getConfidence());
                refEntity.setTextualRepresentation(entity.getTextualRepresentation());
                refEntity.setComponentId("JNET ConsistencyPreservation String (" + entity.getCoveredText() + ", " + begin + "-" + end + ")");
                return refEntity;
            }
            return null;
        }).filter(e -> e != null && !specificIndex.contains((Annotation)e)).map(e -> {
            specificIndex.add((Annotation)e);
            return e;
        }).collect(Collectors.toList()).stream().forEach(e -> e.addToIndexes());
    }
}

