/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.classify.constraints.ge;

import cc.mallet.classify.constraints.ge.MaxEntGEConstraint;
import cc.mallet.types.FeatureVector;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import gnu.trove.TDoubleArrayList;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntObjectHashMap;
import java.util.BitSet;

public abstract class MaxEntFLGEConstraints
implements MaxEntGEConstraint {
    protected boolean useValues;
    protected int numLabels;
    protected int numFeatures;
    protected TIntObjectHashMap<MaxEntFLGEConstraint> constraints;
    protected TIntArrayList indexCache;
    protected TDoubleArrayList valueCache;

    public MaxEntFLGEConstraints(int numFeatures, int numLabels, boolean useValues) {
        this.numFeatures = numFeatures;
        this.numLabels = numLabels;
        this.useValues = useValues;
        this.constraints = new TIntObjectHashMap();
        this.indexCache = new TIntArrayList();
        this.valueCache = new TDoubleArrayList();
    }

    public abstract void addConstraint(int var1, double[] var2, double var3);

    @Override
    public double getCompositeConstraintFeatureValue(FeatureVector input, int label) {
        double value = 0.0;
        int i = 0;
        while (i < this.indexCache.size()) {
            value = this.useValues ? (value += this.constraints.get(this.indexCache.getQuick(i)).getValue(label) * this.valueCache.getQuick(i)) : (value += this.constraints.get(this.indexCache.getQuick(i)).getValue(label));
            ++i;
        }
        return value;
    }

    @Override
    public void computeExpectations(FeatureVector input, double[] dist, double weight) {
        this.preProcess(input);
        int li = 0;
        while (li < this.numLabels) {
            double p = weight * dist[li];
            int i = 0;
            while (i < this.indexCache.size()) {
                if (this.useValues) {
                    int n = li;
                    this.constraints.get((int)this.indexCache.getQuick((int)i)).expectation[n] = this.constraints.get((int)this.indexCache.getQuick((int)i)).expectation[n] + p * this.valueCache.getQuick(i);
                } else {
                    int n = li;
                    this.constraints.get((int)this.indexCache.getQuick((int)i)).expectation[n] = this.constraints.get((int)this.indexCache.getQuick((int)i)).expectation[n] + p;
                }
                ++i;
            }
            ++li;
        }
    }

    @Override
    public void zeroExpectations() {
        int[] nArray = this.constraints.keys();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int fi = nArray[n2];
            this.constraints.get((int)fi).expectation = new double[this.numLabels];
            ++n2;
        }
    }

    @Override
    public BitSet preProcess(InstanceList data) {
        int ii = 0;
        BitSet bitSet = new BitSet(data.size());
        for (Instance instance : data) {
            double weight = data.getInstanceWeight(instance);
            FeatureVector fv = (FeatureVector)instance.getData();
            int loc = 0;
            while (loc < fv.numLocations()) {
                int fi = fv.indexAtLocation(loc);
                if (this.constraints.containsKey(fi)) {
                    this.constraints.get((int)fi).count = this.useValues ? (this.constraints.get((int)fi).count += weight * fv.valueAtLocation(loc)) : (this.constraints.get((int)fi).count += weight);
                    bitSet.set(ii);
                }
                ++loc;
            }
            ++ii;
            if (!this.constraints.containsKey(this.numFeatures)) continue;
            bitSet.set(ii);
            this.constraints.get((int)this.numFeatures).count += weight;
        }
        return bitSet;
    }

    @Override
    public void preProcess(FeatureVector input) {
        this.indexCache.resetQuick();
        if (this.useValues) {
            this.valueCache.resetQuick();
        }
        int loc = 0;
        while (loc < input.numLocations()) {
            int fi = input.indexAtLocation(loc);
            if (this.constraints.containsKey(fi)) {
                this.indexCache.add(fi);
                if (this.useValues) {
                    this.valueCache.add(input.valueAtLocation(loc));
                }
            }
            ++loc;
        }
        if (this.constraints.containsKey(this.numFeatures)) {
            this.indexCache.add(this.numFeatures);
            if (this.useValues) {
                this.valueCache.add(1.0);
            }
        }
    }

    protected abstract class MaxEntFLGEConstraint {
        protected double[] target;
        protected double[] expectation;
        protected double count;
        protected double weight;

        public MaxEntFLGEConstraint(double[] target, double weight) {
            this.target = target;
            this.weight = weight;
            this.expectation = null;
            this.count = 0.0;
        }

        public double[] getTarget() {
            return this.target;
        }

        public double[] getExpectation() {
            return this.expectation;
        }

        public double getCount() {
            return this.count;
        }

        public double getWeight() {
            return this.weight;
        }

        public abstract double getValue(int var1);
    }
}

