/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.classify.examples;

import cc.mallet.classify.Classifier;
import cc.mallet.classify.NaiveBayesTrainer;
import cc.mallet.pipe.CharSequence2TokenSequence;
import cc.mallet.pipe.CharSubsequence;
import cc.mallet.pipe.FeatureSequence2FeatureVector;
import cc.mallet.pipe.Input2CharSequence;
import cc.mallet.pipe.Pipe;
import cc.mallet.pipe.PrintInputAndTarget;
import cc.mallet.pipe.SerialPipes;
import cc.mallet.pipe.Target2Label;
import cc.mallet.pipe.TokenSequence2FeatureSequence;
import cc.mallet.pipe.TokenSequenceLowercase;
import cc.mallet.pipe.TokenSequenceRemoveStopwords;
import cc.mallet.pipe.iterator.FileIterator;
import cc.mallet.types.InstanceList;
import java.io.File;

public class DocumentClassifier {
    public static void main(String[] args) {
        File[] directories = new File[args.length];
        int i = 0;
        while (i < args.length) {
            directories[i] = new File(args[i]);
            ++i;
        }
        SerialPipes instancePipe = new SerialPipes(new Pipe[]{new Target2Label(), new Input2CharSequence(), new CharSubsequence(CharSubsequence.SKIP_HEADER), new CharSequence2TokenSequence(), new TokenSequenceLowercase(), new TokenSequenceRemoveStopwords(), new TokenSequence2FeatureSequence(), new FeatureSequence2FeatureVector(), new PrintInputAndTarget()});
        InstanceList ilist = new InstanceList(instancePipe);
        ilist.addThruPipe(new FileIterator(directories, FileIterator.STARTING_DIRECTORIES));
        InstanceList[] ilists = ilist.split(new double[]{0.5, 0.5});
        NaiveBayesTrainer naiveBayesTrainer = new NaiveBayesTrainer();
        Object classifier = naiveBayesTrainer.train(ilists[0]);
        System.out.println("The training accuracy is " + ((Classifier)classifier).getAccuracy(ilists[0]));
        System.out.println("The testing accuracy is " + ((Classifier)classifier).getAccuracy(ilists[1]));
    }
}

