/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.cluster.util;

import cc.mallet.cluster.Clustering;
import cc.mallet.pipe.Noop;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import cc.mallet.util.Randoms;

public class ClusterUtils {
    public static InstanceList combineLists(InstanceList li, InstanceList lj) {
        InstanceList newList = new InstanceList(li.getPipe());
        int i = 0;
        while (i < li.size()) {
            newList.add((Instance)li.get(i));
            ++i;
        }
        i = 0;
        while (i < lj.size()) {
            newList.add((Instance)lj.get(i));
            ++i;
        }
        return newList;
    }

    public static Clustering mergeClusters(Clustering clustering, int labeli, int labelj) {
        int idx;
        if (labeli == labelj) {
            return clustering;
        }
        InstanceList instances = clustering.getInstances();
        int i = 0;
        while (i < instances.size()) {
            idx = clustering.getLabel(i);
            if (idx == labelj) {
                clustering.setLabel(i, labeli);
            }
            ++i;
        }
        clustering.setNumLabels(clustering.getNumClusters() - 1);
        i = 0;
        while (i < instances.size()) {
            idx = clustering.getLabel(i);
            if (idx > labelj) {
                clustering.setLabel(i, idx - 1);
            }
            ++i;
        }
        return clustering;
    }

    public static Clustering mergeInstances(Clustering clustering, int[] instances) {
        int i = 0;
        while (i < instances.length) {
            int j = i + 1;
            while (j < instances.length) {
                int labeli = clustering.getLabel(instances[i]);
                int labelj = clustering.getLabel(instances[j]);
                clustering = ClusterUtils.mergeClusters(clustering, labeli, labelj);
                ++j;
            }
            ++i;
        }
        return clustering;
    }

    public static int[] getCombinedInstances(Clustering clustering, int i, int j) {
        int[] ci = clustering.getIndicesWithLabel(i);
        int[] cj = clustering.getIndicesWithLabel(j);
        int[] merged = new int[ci.length + cj.length];
        System.arraycopy(ci, 0, merged, 0, ci.length);
        System.arraycopy(cj, 0, merged, ci.length, cj.length);
        return merged;
    }

    public static Clustering mergeInstances(Clustering clustering, int i, int j) {
        return ClusterUtils.mergeInstances(clustering, new int[]{i, j});
    }

    public static Clustering createSingletonClustering(InstanceList instances) {
        int[] labels = new int[instances.size()];
        int i = 0;
        while (i < labels.length) {
            labels[i] = i;
            ++i;
        }
        return new Clustering(instances, labels.length, labels);
    }

    public static Clustering createRandomClustering(InstanceList instances, Randoms random) {
        Clustering clustering = ClusterUtils.createSingletonClustering(instances);
        int numMerges = 2 + random.nextInt(instances.size() - 2);
        int i = 0;
        while (i < numMerges) {
            clustering = ClusterUtils.mergeInstances(clustering, random.nextInt(instances.size()), random.nextInt(instances.size()));
            ++i;
        }
        return clustering;
    }

    public static Clustering shatterInstances(Clustering clustering, int[] indices) {
        int i = 0;
        while (i < indices.length - 1) {
            clustering.setLabel(indices[i], clustering.getNumClusters());
            clustering.setNumLabels(clustering.getNumClusters() + 1);
            ++i;
        }
        return clustering;
    }

    public static InstanceList makeList(Instance i, Instance j) {
        InstanceList list = new InstanceList(new Noop(i.getDataAlphabet(), i.getTargetAlphabet()));
        list.add(i);
        list.add(j);
        return list;
    }

    public static Clustering copyWithNewLabels(Clustering clustering) {
        int[] oldLabels = clustering.getLabels();
        int[] newLabels = new int[oldLabels.length];
        System.arraycopy(oldLabels, 0, newLabels, 0, oldLabels.length);
        return new Clustering(clustering.getInstances(), clustering.getNumClusters(), newLabels);
    }

    public static Clustering mergeInstancesWithSameLabel(Clustering clustering) {
        InstanceList list = clustering.getInstances();
        int i = 0;
        while (i < list.size()) {
            Instance ii = (Instance)list.get(i);
            int li = clustering.getLabel(i);
            int j = i + 1;
            while (j < list.size()) {
                Instance ij = (Instance)list.get(j);
                int lj = clustering.getLabel(j);
                if (li != lj && ii.getLabeling().equals(ij.getLabeling())) {
                    clustering = ClusterUtils.mergeClusters(clustering, li, lj);
                }
                ++j;
            }
            ++i;
        }
        return clustering;
    }

    public static Clustering copyAndMergeClusters(Clustering clustering, int i, int j) {
        return ClusterUtils.mergeClusters(ClusterUtils.copyWithNewLabels(clustering), i, j);
    }

    public static Clustering copyAndMergeInstances(Clustering clustering, int i, int j) {
        return ClusterUtils.copyAndMergeInstances(clustering, new int[]{i, j});
    }

    public static Clustering copyAndMergeInstances(Clustering clustering, int[] instances) {
        return ClusterUtils.mergeInstances(ClusterUtils.copyWithNewLabels(clustering), instances);
    }
}

