/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.fst.semi_supervised.constraints;

import cc.mallet.fst.semi_supervised.StateLabelMap;
import cc.mallet.fst.semi_supervised.constraints.GEConstraint;
import cc.mallet.fst.semi_supervised.constraints.TwoLabelGEConstraints;
import gnu.trove.TIntIntHashMap;
import java.util.ArrayList;

public class TwoLabelKLGEConstraints
extends TwoLabelGEConstraints {
    public TwoLabelKLGEConstraints() {
    }

    private TwoLabelKLGEConstraints(ArrayList<TwoLabelGEConstraints.TwoLabelGEConstraint> constraintsList, TIntIntHashMap constraintsMap, StateLabelMap map) {
        super(constraintsList, constraintsMap, map);
    }

    @Override
    public GEConstraint copy() {
        return new TwoLabelKLGEConstraints(this.constraintsList, this.constraintsMap, this.map);
    }

    @Override
    public void addConstraint(int fi, double[][] target, double weight) {
        this.constraintsList.add(new TwoLabelKLGEConstraint(target, weight));
        this.constraintsMap.put(fi, this.constraintsList.size() - 1);
    }

    @Override
    public double getValue() {
        double value = 0.0;
        int[] nArray = this.constraintsMap.keys();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int fi = nArray[n2];
            TwoLabelGEConstraints.TwoLabelGEConstraint constraint = (TwoLabelGEConstraints.TwoLabelGEConstraint)this.constraintsList.get(this.constraintsMap.get(fi));
            if (constraint.count > 0.0) {
                double constraintValue = 0.0;
                int prevLi = 0;
                while (prevLi < this.map.getNumLabels()) {
                    int currLi = 0;
                    while (currLi < this.map.getNumLabels()) {
                        if (constraint.target[prevLi][currLi] > 0.0) {
                            if (constraint.expectation[prevLi][currLi] == 0.0) {
                                return Double.NEGATIVE_INFINITY;
                            }
                            constraintValue += constraint.target[prevLi][currLi] * (Math.log(constraint.expectation[prevLi][currLi] / constraint.count) - Math.log(constraint.target[prevLi][currLi]));
                        }
                        ++currLi;
                    }
                    ++prevLi;
                }
                assert (!Double.isNaN(constraintValue) && !Double.isInfinite(constraintValue));
                value += constraintValue * constraint.weight;
            }
            ++n2;
        }
        return value;
    }

    protected class TwoLabelKLGEConstraint
    extends TwoLabelGEConstraints.TwoLabelGEConstraint {
        public TwoLabelKLGEConstraint(double[][] target, double weight) {
            super(TwoLabelKLGEConstraints.this, target, weight);
        }

        @Override
        public double getValue(int liPrev, int liCurr) {
            assert (this.count != 0.0);
            if (this.target[liPrev][liCurr] == 0.0 && this.expectation[liPrev][liCurr] == 0.0) {
                return 0.0;
            }
            return this.weight * (this.target[liPrev][liCurr] / this.expectation[liPrev][liCurr]);
        }
    }
}

