/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.grmm.types;

import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class Tree {
    private TObjectIntHashMap vertex2int = new TObjectIntHashMap();
    private ArrayList int2vertex = new ArrayList();
    private ArrayList parents = new ArrayList();
    private ArrayList children = new ArrayList();
    private Object root = null;

    public static Tree makeFromSubtree(Object parent, List subtrees) {
        Tree tree = new Tree();
        tree.add(parent);
        for (Tree subtree : subtrees) {
            tree.addSubtree(parent, subtree, subtree.getRoot());
        }
        return tree;
    }

    private void addSubtree(Object parent, Tree subtree, Object child) {
        this.addNode(parent, child);
        for (Object gchild : subtree.getChildren(child)) {
            this.addSubtree(child, subtree, gchild);
        }
    }

    protected int lookupIndex(Object v) {
        return this.vertex2int.get(v);
    }

    protected Object lookupVertex(int idx) {
        return this.int2vertex.get(idx);
    }

    int maybeAddVertex(Object v) {
        if (!this.vertex2int.containsKey(v)) {
            int foo = this.int2vertex.size();
            this.int2vertex.add(v);
            this.vertex2int.put(v, foo);
            this.parents.add(null);
            this.children.add(new ArrayList());
            return foo;
        }
        return this.vertex2int.get(v);
    }

    public void add(Object rt) {
        if (this.root != null) {
            throw new UnsupportedOperationException("This tree already has a root.");
        }
        this.maybeAddVertex(rt);
        this.root = rt;
    }

    public void addNode(Object parent, Object child) {
        int id1;
        if (this.root == null) {
            this.root = parent;
            id1 = this.maybeAddVertex(parent);
        } else {
            id1 = this.lookupIndex(parent);
            if (id1 == -1) {
                throw new UnsupportedOperationException("This tree already has a root.");
            }
        }
        int id2 = this.maybeAddVertex(child);
        Object oldParent = this.parents.get(id2);
        if (oldParent != null && oldParent != parent) {
            throw new UnsupportedOperationException("Trying to change parent of Object " + child + " from " + oldParent + " to " + parent);
        }
        this.parents.set(id2, parent);
        ArrayList childList = (ArrayList)this.children.get(id1);
        childList.add(child);
    }

    public Object getParent(Object child) {
        if (this.vertex2int.containsKey(child)) {
            return this.parents.get(this.vertex2int.get(child));
        }
        return null;
    }

    public List getChildren(Object parent) {
        int id = this.vertex2int.get(parent);
        return Collections.unmodifiableList((List)this.children.get(id));
    }

    public boolean isRoot(Object var) {
        int idx = this.lookupIndex(var);
        return this.parents.get(idx) == null;
    }

    public boolean containsObject(Object v) {
        return this.vertex2int.get(v) >= 0;
    }

    public boolean isLeaf(Object v) {
        int idx = this.lookupIndex(v);
        return ((List)this.children.get(idx)).size() == 0;
    }

    public Iterator getVerticesIterator() {
        return this.int2vertex.iterator();
    }

    public Object getRoot() {
        return this.root;
    }

    public String dumpToString() {
        StringBuffer buf = new StringBuffer();
        this.dumpRec(this.root, 0, buf);
        return buf.toString();
    }

    private void dumpRec(Object node, int lvl, StringBuffer buf) {
        int i = 0;
        while (i < 3 * lvl) {
            buf.append("-");
            ++i;
        }
        buf.append("  ").append(node).append("\n");
        for (Object child : this.getChildren(node)) {
            this.dumpRec(child, lvl + 1, buf);
        }
    }
}

