/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.grmm.types;

import cc.mallet.grmm.types.BidirectionalIntObjectMap;
import cc.mallet.grmm.types.VarSet;
import cc.mallet.grmm.types.Variable;
import gnu.trove.THashMap;
import gnu.trove.TIntObjectHashMap;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;

public class Universe
implements Serializable {
    private BidirectionalIntObjectMap variableAlphabet = new BidirectionalIntObjectMap();
    public static Universe DEFAULT = new Universe();
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 1;
    static THashMap allProjectionCaches = new THashMap();

    public static void resetUniverse() {
        DEFAULT = new Universe();
        allProjectionCaches = new THashMap();
    }

    public int add(Variable var) {
        return this.variableAlphabet.lookupIndex(var, true);
    }

    public Variable get(int idx) {
        return (Variable)this.variableAlphabet.lookupObject(idx);
    }

    public int getIndex(Variable var) {
        return this.variableAlphabet.lookupIndex(var);
    }

    public int size() {
        return this.variableAlphabet.size();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(1);
        out.writeObject(this.variableAlphabet.toArray());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int version = in.readInt();
        Object[] vars = (Object[])in.readObject();
        this.variableAlphabet = new BidirectionalIntObjectMap(vars.length);
        int vi = 0;
        while (vi < vars.length) {
            this.add((Variable)vars[vi]);
            ++vi;
        }
    }

    public TIntObjectHashMap lookupProjectionCache(VarSet varSet) {
        ArrayList<Integer> sizes = new ArrayList<Integer>(varSet.size());
        int vi = 0;
        while (vi < varSet.size()) {
            sizes.add(varSet.get(vi).getNumOutcomes());
            ++vi;
        }
        TIntObjectHashMap result = (TIntObjectHashMap)allProjectionCaches.get(sizes);
        if (result == null) {
            result = new TIntObjectHashMap();
            allProjectionCaches.put(sizes, result);
        }
        return result;
    }
}

