/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.pipe;

import cc.mallet.pipe.Pipe;
import cc.mallet.types.Instance;
import cc.mallet.types.Token;
import cc.mallet.types.TokenSequence;
import cc.mallet.util.MalletLogger;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TokenSequenceMatchDataAndTarget
extends Pipe
implements Serializable {
    private static Logger logger = MalletLogger.getLogger(TokenSequenceMatchDataAndTarget.class.getName());
    Pattern regex;
    int dataGroup;
    int targetGroup;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 1;

    public TokenSequenceMatchDataAndTarget(Pattern regex, int dataGroup, int targetGroup) {
        this.regex = regex;
        this.dataGroup = dataGroup;
        this.targetGroup = targetGroup;
    }

    public TokenSequenceMatchDataAndTarget(String regex, int dataGroup, int targetGroup) {
        this(Pattern.compile(regex), dataGroup, targetGroup);
    }

    @Override
    public Instance pipe(Instance carrier) {
        TokenSequence ts = (TokenSequence)carrier.getData();
        TokenSequence targetTokenSeq = new TokenSequence(ts.size());
        int i = 0;
        while (i < ts.size()) {
            Token t = (Token)ts.get(i);
            Matcher matcher = this.regex.matcher(t.getText());
            if (matcher.matches()) {
                targetTokenSeq.add(matcher.group(this.targetGroup));
                t.setText(matcher.group(this.dataGroup));
            } else {
                logger.warning("Skipping token: No match of " + this.regex.pattern() + " at token #" + i + " with text " + t.getText());
            }
            ++i;
        }
        carrier.setTarget(targetTokenSeq);
        carrier.setData(ts);
        return carrier;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(1);
        out.writeObject(this.regex.pattern());
        out.writeInt(this.regex.flags());
        out.writeInt(this.dataGroup);
        out.writeInt(this.targetGroup);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        if (version < 1) {
            this.regex = (Pattern)in.readObject();
        } else {
            String p = (String)in.readObject();
            int flags = in.readInt();
            this.regex = Pattern.compile(p, flags);
        }
        this.dataGroup = in.readInt();
        this.targetGroup = in.readInt();
    }
}

