/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.types;

import cc.mallet.types.FeatureSelection;
import cc.mallet.types.InstanceList;
import cc.mallet.types.RankedFeatureVector;
import cc.mallet.util.MalletLogger;
import java.util.logging.Logger;

public class FeatureSelector {
    private static Logger logger = MalletLogger.getLogger(FeatureSelector.class.getName());
    RankedFeatureVector.Factory ranker;
    RankedFeatureVector.PerLabelFactory perLabelRanker;
    int numFeatures = -1;
    double minThreshold = Double.POSITIVE_INFINITY;

    public FeatureSelector(RankedFeatureVector.Factory ranker, int numFeatures) {
        this.ranker = ranker;
        this.numFeatures = numFeatures;
    }

    public FeatureSelector(RankedFeatureVector.Factory ranker, double minThreshold) {
        this.ranker = ranker;
        this.minThreshold = minThreshold;
    }

    public FeatureSelector(RankedFeatureVector.PerLabelFactory perLabelRanker, int numFeatures) {
        this.perLabelRanker = perLabelRanker;
        this.numFeatures = numFeatures;
    }

    public FeatureSelector(RankedFeatureVector.PerLabelFactory perLabelRanker, double minThreshold) {
        this.perLabelRanker = perLabelRanker;
        this.minThreshold = minThreshold;
    }

    public void selectFeaturesFor(InstanceList ilist) {
        if (this.perLabelRanker != null) {
            this.selectFeaturesForPerLabel(ilist);
        } else {
            this.selectFeaturesForAllLabels(ilist);
        }
    }

    public void selectFeaturesForAllLabels(InstanceList ilist) {
        RankedFeatureVector ranking = this.ranker.newRankedFeatureVector(ilist);
        FeatureSelection fs = new FeatureSelection(ilist.getDataAlphabet());
        if (this.numFeatures != -1) {
            int nf = Math.min(this.numFeatures, ranking.singleSize());
            int i = 0;
            while (i < nf) {
                logger.info("adding feature " + i + " word=" + ilist.getDataAlphabet().lookupObject(ranking.getIndexAtRank(i)));
                fs.add(ranking.getIndexAtRank(i));
                ++i;
            }
        } else {
            int i = 0;
            while (i < ranking.singleSize()) {
                if (ranking.getValueAtRank(i) > this.minThreshold) {
                    fs.add(ranking.getIndexAtRank(i));
                }
                ++i;
            }
        }
        logger.info("Selected " + fs.cardinality() + " features from " + ilist.getDataAlphabet().size() + " features");
        ilist.setPerLabelFeatureSelection(null);
        ilist.setFeatureSelection(fs);
    }

    public void selectFeaturesForPerLabel(InstanceList ilist) {
        RankedFeatureVector[] rankings = this.perLabelRanker.newRankedFeatureVectors(ilist);
        int numClasses = rankings.length;
        FeatureSelection[] fs = new FeatureSelection[numClasses];
        int i = 0;
        while (i < numClasses) {
            int j;
            fs[i] = new FeatureSelection(ilist.getDataAlphabet());
            RankedFeatureVector ranking = rankings[i];
            int nf = Math.min(this.numFeatures, ranking.singleSize());
            if (nf >= 0) {
                j = 0;
                while (j < nf) {
                    fs[i].add(ranking.getIndexAtRank(j));
                    ++j;
                }
            } else {
                j = 0;
                while (j < ranking.singleSize()) {
                    if (ranking.getValueAtRank(j) > this.minThreshold) {
                        fs[i].add(ranking.getIndexAtRank(j));
                        ++j;
                        continue;
                    }
                    break;
                }
            }
            ++i;
        }
        ilist.setFeatureSelection(null);
        ilist.setPerLabelFeatureSelection(fs);
    }
}

