/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class Replacement
implements Serializable {
    String target;
    String[] tokens;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 1;

    public Replacement(String line) {
        String[] fields = line.split("\t");
        this.tokens = fields[0].split(" ");
        if (fields.length == 2) {
            this.target = fields[1].replaceAll("\\s+", "_");
        } else if (fields.length == 1) {
            this.target = fields[0].replaceAll("\\s+", "_");
        }
        if (Character.getType(this.target.codePointAt(0)) == 9) {
            this.target = "_" + this.target;
        }
    }

    public Replacement(String source, String target) {
        this.tokens = source.split(" ");
        this.target = target;
    }

    public int apply(String[] input, int startPosition, StringBuilder output) {
        int i = 1;
        while (i < this.tokens.length) {
            if (startPosition + i >= input.length) {
                return startPosition;
            }
            if (!input[startPosition + i].equals(this.tokens[i])) {
                return startPosition;
            }
            ++i;
        }
        input[startPosition] = this.target;
        output.append(String.valueOf(this.target) + " ");
        return startPosition + this.tokens.length;
    }

    public String getFirstToken() {
        return this.tokens[0];
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(1);
        out.writeObject(this.target);
        out.writeObject(this.tokens);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        this.target = (String)in.readObject();
        this.tokens = (String[])in.readObject();
    }
}

