/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.java.utilities.prerequisites;

import de.julielab.java.utilities.prerequisites.EmptyChecker;
import de.julielab.java.utilities.prerequisites.NullChecker;
import de.julielab.java.utilities.prerequisites.ParameterChecker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class PrerequisiteChecker {
    public static final String PREREQUISITE_CHECKS_ENABLED = "de.julielab.prerequisitechecksenabled";
    private static final PrerequisiteChecker DISABLED_CHECKER = new PrerequisiteChecker(false);
    private final boolean enabled;
    private Set<String> errorMessages;
    private List<ParameterChecker> checkers;

    public PrerequisiteChecker() {
        this.enabled = Boolean.parseBoolean(System.getProperty(PREREQUISITE_CHECKS_ENABLED));
        this.errorMessages = new LinkedHashSet<String>();
        this.checkers = new ArrayList<ParameterChecker>();
    }

    private PrerequisiteChecker(boolean enabled) {
        this.enabled = false;
    }

    public static PrerequisiteChecker checkThat() {
        return Boolean.parseBoolean(System.getProperty(PREREQUISITE_CHECKS_ENABLED)) ? new PrerequisiteChecker() : DISABLED_CHECKER;
    }

    void addErrorMessage(String message) {
        this.errorMessages.add(message);
    }

    public PrerequisiteChecker withNames(String ... names) {
        if (this.enabled) {
            if (this.checkers.isEmpty()) {
                throw new IllegalStateException("No items have been added to the prerequisite checker, cannot assign names.");
            }
            this.checkers.get(this.checkers.size() - 1).withNames(names);
        }
        return this;
    }

    public PrerequisiteChecker notNull(Object ... objects) {
        if (this.enabled) {
            this.checkers.add(new NullChecker<Object>(this, (T[])objects));
        }
        return this;
    }

    public PrerequisiteChecker notEmpty(Collection<?> ... collections) {
        if (this.enabled) {
            this.checkers.add(new EmptyChecker(this, collections));
        }
        return this;
    }

    public PrerequisiteChecker supplyNotEmpty(Supplier<Collection<?>> ... collections) {
        if (this.enabled) {
            this.checkers.add(new EmptyChecker(this, collections));
        }
        return this;
    }

    public PrerequisiteChecker supplyNotNull(Supplier<?> ... objectSuppliers) {
        if (this.enabled) {
            this.checkers.add(new NullChecker(this, (T[])objectSuppliers));
        }
        return this;
    }

    public void execute() {
        if (this.enabled) {
            for (ParameterChecker checker : this.checkers) {
                checker.check();
            }
            if (!this.errorMessages.isEmpty()) {
                throw new IllegalArgumentException("There were parameter check failures: " + System.getProperty("line.separator") + this.errorMessages.stream().collect(Collectors.joining(System.getProperty("line.separator"))));
            }
        }
    }

    private static enum ObjectType {
        OBJECT,
        COLLECTION,
        SUPPLIER;

    }
}

