/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.ae.jnet.tagger;

import java.util.ArrayList;

public class NGramGenerator {
    public ArrayList<String> generateTokenNGrams(String[] tokens, int currPos, int[] ngramSizes) {
        ArrayList<String> allNGrams = new ArrayList<String>();
        for (int ngramSize : ngramSizes) {
            allNGrams.addAll(this.generateTokenNGrams(tokens, currPos, ngramSize));
        }
        return allNGrams;
    }

    public ArrayList<String> generateTokenNGrams(String[] tokens, int currPos, int ngramSize) {
        if (currPos > tokens.length - 1) {
            return null;
        }
        int minStart = Math.max(0, currPos - ngramSize + 1);
        int maxStart = Math.min(currPos, tokens.length - 1);
        ArrayList<String> ngrams = new ArrayList<String>();
        for (int i = minStart; i <= maxStart; ++i) {
            if (i + ngramSize > tokens.length) continue;
            StringBuffer ngram = new StringBuffer();
            for (int j = 0; j < ngramSize; ++j) {
                ngram.append(tokens[i + j] + " ");
            }
            ngrams.add(ngram.toString().trim());
        }
        return ngrams;
    }

    public static void main(String[] args) {
        String[] tokens = new String[]{"0", "1", "2", "3", "4", "5"};
        System.out.println(new NGramGenerator().generateTokenNGrams(tokens, 2, new int[]{2, 3, 4}));
    }
}

