/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.utilities;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.didion.jwnl.JWNL;
import net.didion.jwnl.data.Exc;
import net.didion.jwnl.data.IndexWord;
import net.didion.jwnl.data.POS;
import net.didion.jwnl.data.Pointer;
import net.didion.jwnl.data.Synset;
import net.didion.jwnl.data.Verb;
import net.didion.jwnl.data.Word;
import net.didion.jwnl.dictionary.AbstractCachingDictionary;
import net.didion.jwnl.dictionary.Dictionary;
import net.didion.jwnl.dictionary.database.ConnectionManager;
import net.didion.jwnl.util.MessageLog;
import net.didion.jwnl.util.MessageLogLevel;
import net.didion.jwnl.util.TokenizerParser;

public class DictionaryToDatabaseWithUsageCount {
    private static final MessageLog LOG;
    private static int INTERNAL_ID;
    private static long TIME;
    private Connection connection;
    private Map idToSynsetOffset = new HashMap();
    private Map synsetOffsetToId = new HashMap();
    private Map usageMap = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length < 4) {
            System.out.println("java net.didion.jwnl.utilities.DictionaryToDatabase <property file> <create tables script> <driver class> <connection url> [username [password]]");
            System.exit(-1);
        }
        try {
            JWNL.initialize(new FileInputStream(args[0]));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(-1);
        }
        Connection conn = null;
        try {
            String indexSenseFileName = args[1];
            String scriptFileName = args[2];
            ConnectionManager mgr = new ConnectionManager(args[3], args[4], args.length <= 5 ? null : args[5], args.length <= 6 ? null : args[6]);
            conn = mgr.getConnection();
            DictionaryToDatabaseWithUsageCount d2d = new DictionaryToDatabaseWithUsageCount(conn);
            d2d.loadSenseKeyAndUsage(indexSenseFileName);
            d2d.createTables(scriptFileName);
            d2d.insertData();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private static synchronized int nextId() {
        if (LOG.isLevelEnabled(MessageLogLevel.DEBUG) && ++INTERNAL_ID % 1000 == 0) {
            long temp = System.currentTimeMillis();
            LOG.log(MessageLogLevel.DEBUG, "inserted " + INTERNAL_ID + "th entry");
            LOG.log(MessageLogLevel.DEBUG, "free memory: " + Runtime.getRuntime().freeMemory());
            LOG.log(MessageLogLevel.DEBUG, "time: " + (temp - TIME));
            TIME = System.currentTimeMillis();
        }
        return INTERNAL_ID;
    }

    public DictionaryToDatabaseWithUsageCount(Connection conn) {
        this.connection = conn;
        ((AbstractCachingDictionary)Dictionary.getInstance()).setCachingEnabled(false);
    }

    public void createTables(String scriptFilePath) throws IOException, SQLException {
        LOG.log(MessageLogLevel.INFO, "creating tables");
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(scriptFilePath)));
        StringBuffer buf = new StringBuffer();
        String line = reader.readLine();
        while (line != null) {
            if ((line = line.trim()).length() > 0) {
                buf.append(line);
                if (line.endsWith(";")) {
                    System.out.println(buf.toString());
                    this.connection.prepareStatement(buf.toString()).execute();
                    buf = new StringBuffer();
                } else {
                    buf.append(" ");
                }
            }
            line = reader.readLine();
        }
        LOG.log(MessageLogLevel.INFO, "creating tables");
    }

    public void insertData() throws Exception {
        TIME = System.currentTimeMillis();
        for (POS pos : POS.getAllPOS()) {
            LOG.log(MessageLogLevel.INFO, "inserting data for pos " + pos);
            this.storeIndexWords(Dictionary.getInstance().getIndexWordIterator(pos));
            this.storeSynsets(Dictionary.getInstance().getSynsetIterator(pos));
            this.storeIndexWordSynsets();
            this.storeExceptions(Dictionary.getInstance().getExceptionIterator(pos));
            this.idToSynsetOffset.clear();
            this.synsetOffsetToId.clear();
            LOG.log(MessageLogLevel.INFO, "done inserting data for pos " + pos);
        }
    }

    private void storeIndexWords(Iterator itr) throws SQLException {
        LOG.log(MessageLogLevel.INFO, "storing index words");
        PreparedStatement iwStmt = this.connection.prepareStatement("INSERT INTO IndexWord VALUES(?,?,?)");
        int count = 0;
        while (itr.hasNext()) {
            IndexWord iw = (IndexWord)itr.next();
            int id = DictionaryToDatabaseWithUsageCount.nextId();
            iwStmt.setInt(1, id);
            iwStmt.setString(2, iw.getLemma());
            iwStmt.setString(3, iw.getPOS().getKey());
            iwStmt.execute();
            this.idToSynsetOffset.put(new Integer(id), iw.getSynsetOffsets());
            if (count++ % 1000 != 0) continue;
            System.out.println(count);
        }
    }

    private void storeSynsets(Iterator itr) throws SQLException {
        PreparedStatement synsetStmt = this.connection.prepareStatement("INSERT INTO Synset VALUES(?,?,?,?,?)");
        PreparedStatement synsetWordStmt = this.connection.prepareStatement("INSERT INTO SynsetWord VALUES(?,?,?,?,?,?)");
        PreparedStatement synsetPointerStmt = this.connection.prepareStatement("INSERT INTO SynsetPointer VALUES(?,?,?,?,?,?,?)");
        PreparedStatement synsetVerbFrameStmt = this.connection.prepareStatement("INSERT INTO SynsetVerbFrame VALUES(?,?,?,?)");
        LOG.log(MessageLogLevel.INFO, "storing synsets");
        int count = 0;
        while (itr.hasNext()) {
            if (count++ % 1000 == 0) {
                System.out.println("synset: " + count);
            }
            Synset synset = (Synset)itr.next();
            int id = DictionaryToDatabaseWithUsageCount.nextId();
            this.synsetOffsetToId.put(new Long(synset.getOffset()), new Integer(id));
            synsetStmt.setInt(1, id);
            synsetStmt.setLong(2, synset.getOffset());
            synsetStmt.setString(3, synset.getPOS().getKey());
            synsetStmt.setBoolean(4, synset.isAdjectiveCluster());
            synsetStmt.setString(5, synset.getGloss());
            synsetStmt.execute();
            Word[] words = synset.getWords();
            synsetWordStmt.setInt(2, id);
            synsetVerbFrameStmt.setInt(2, id);
            for (int i = 0; i < words.length; ++i) {
                int wordId = DictionaryToDatabaseWithUsageCount.nextId();
                String synsetString = synset.getOffset() + ":" + words[i].getLemma();
                Object[] arr = (Object[])this.usageMap.get(synsetString);
                String senseKey = "";
                int usageCnt = 0;
                if (arr != null) {
                    senseKey = (String)arr[0];
                    usageCnt = (Integer)arr[1];
                }
                synsetWordStmt.setInt(1, wordId);
                synsetWordStmt.setString(3, words[i].getLemma());
                synsetWordStmt.setInt(4, words[i].getIndex());
                synsetWordStmt.setString(5, senseKey);
                synsetWordStmt.setInt(6, usageCnt);
                synsetWordStmt.execute();
                if (!(words[i] instanceof Verb)) continue;
                synsetVerbFrameStmt.setInt(4, words[i].getIndex());
                int[] flags = ((Verb)words[i]).getVerbFrameIndicies();
                for (int j = 0; j < flags.length; ++j) {
                    synsetVerbFrameStmt.setInt(1, DictionaryToDatabaseWithUsageCount.nextId());
                    synsetVerbFrameStmt.setInt(3, flags[j]);
                    synsetVerbFrameStmt.execute();
                }
            }
            Pointer[] pointers = synset.getPointers();
            synsetPointerStmt.setInt(2, id);
            for (int i = 0; i < pointers.length; ++i) {
                synsetPointerStmt.setInt(1, DictionaryToDatabaseWithUsageCount.nextId());
                synsetPointerStmt.setString(3, pointers[i].getType().getKey());
                synsetPointerStmt.setLong(4, pointers[i].getTargetOffset());
                synsetPointerStmt.setString(5, pointers[i].getTargetPOS().getKey());
                synsetPointerStmt.setInt(6, pointers[i].getSourceIndex());
                synsetPointerStmt.setInt(7, pointers[i].getTargetIndex());
                synsetPointerStmt.execute();
            }
        }
    }

    private void storeIndexWordSynsets() throws SQLException {
        LOG.log(MessageLogLevel.INFO, "storing index word synsets");
        PreparedStatement iwsStmt = this.connection.prepareStatement("INSERT INTO IndexWordSynset VALUES(?,?,?)");
        for (Map.Entry entry : this.idToSynsetOffset.entrySet()) {
            int iwId = (Integer)entry.getKey();
            iwsStmt.setInt(2, iwId);
            long[] offsets = (long[])entry.getValue();
            for (int i = 0; i < offsets.length; ++i) {
                Integer offset = (Integer)this.synsetOffsetToId.get(new Long(offsets[i]));
                int synsetId = offset;
                iwsStmt.setInt(1, DictionaryToDatabaseWithUsageCount.nextId());
                iwsStmt.setLong(3, synsetId);
                iwsStmt.execute();
            }
        }
    }

    private void loadSenseKeyAndUsage(String filename) throws SQLException {
        LOG.log(MessageLogLevel.INFO, "storing sense key usage");
        try {
            BufferedReader in = new BufferedReader(new FileReader(filename));
            int count = 0;
            while (in.ready()) {
                String indexLine = in.readLine();
                TokenizerParser tokenizer = new TokenizerParser(indexLine, " ");
                String senseKey = tokenizer.nextToken();
                String[] lemmaKey = senseKey.split("%");
                String lemma = lemmaKey[0];
                long ofs = tokenizer.nextLong();
                tokenizer.nextInt();
                String synsetString = ofs + ":" + lemma;
                if (count++ % 1000 == 0) {
                    System.out.println("sense key and usage: " + count);
                }
                String senseCount = tokenizer.nextToken();
                String[] sc = null;
                Object[] arr = new Object[2];
                sc = JWNL.getVersion().getNumber() < 2.1 && JWNL.getOS().equals(JWNL.WINDOWS) ? senseCount.split("\\r\\n") : senseCount.split("\\n");
                if (sc == null) continue;
                int cnt = Integer.parseInt(sc[0]);
                arr[0] = senseKey;
                arr[1] = new Integer(cnt);
                this.usageMap.put(synsetString, arr);
                senseCount.trim();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void storeExceptions(Iterator itr) throws SQLException {
        LOG.log(MessageLogLevel.INFO, "storing exceptions");
        PreparedStatement exStmt = this.connection.prepareStatement("INSERT INTO Exception VALUES(?,?,?,?)");
        while (itr.hasNext()) {
            Exc exc = (Exc)itr.next();
            exStmt.setString(4, exc.getLemma());
            Iterator excItr = exc.getExceptions().iterator();
            while (excItr.hasNext()) {
                exStmt.setInt(1, DictionaryToDatabaseWithUsageCount.nextId());
                exStmt.setString(2, exc.getPOS().getKey());
                exStmt.setString(3, (String)excItr.next());
                exStmt.execute();
            }
        }
    }

    static {
        INTERNAL_ID = 0;
        TIME = 0L;
        LOG = new MessageLog(DictionaryToDatabaseWithUsageCount.class);
    }
}

