/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.cluster.evaluate;

import cc.mallet.cluster.Clustering;
import cc.mallet.cluster.evaluate.ClusteringEvaluator;
import cc.mallet.types.InstanceList;

public class BCubedEvaluator
extends ClusteringEvaluator {
    double macroPrecision = 0.0;
    double macroRecall = 0.0;
    int macroNumInstances = 0;

    @Override
    public String evaluate(Clustering truth, Clustering predicted) {
        double[] vals = this.getEvaluationScores(truth, predicted);
        return "pr=" + vals[0] + " re=" + vals[1] + " f1=" + vals[2];
    }

    @Override
    public String evaluateTotals() {
        double pr = this.macroPrecision / (double)this.macroNumInstances;
        double re = this.macroRecall / (double)this.macroNumInstances;
        double f1 = 2.0 * pr * re / (pr + re);
        return "pr=" + pr + " re=" + re + " f1=" + f1;
    }

    @Override
    public double[] getEvaluationScores(Clustering truth, Clustering predicted) {
        double precision = 0.0;
        double recall = 0.0;
        InstanceList instances = truth.getInstances();
        int i = 0;
        while (i < instances.size()) {
            int trueLabel = truth.getLabel(i);
            int predLabel = predicted.getLabel(i);
            int[] trueIndices = truth.getIndicesWithLabel(trueLabel);
            int[] predIndices = predicted.getIndicesWithLabel(predLabel);
            int correct = 0;
            int j = 0;
            while (j < predIndices.length) {
                int k = 0;
                while (k < trueIndices.length) {
                    if (trueIndices[k] == predIndices[j]) {
                        ++correct;
                    }
                    ++k;
                }
                ++j;
            }
            precision += (double)correct / (double)predIndices.length;
            recall += (double)correct / (double)trueIndices.length;
            ++i;
        }
        this.macroPrecision += precision;
        this.macroRecall += recall;
        this.macroNumInstances += instances.size();
        return new double[]{precision /= (double)instances.size(), recall /= (double)instances.size(), 2.0 * precision * recall / (precision + recall)};
    }
}

