/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.cluster.evaluate;

import cc.mallet.cluster.Clustering;
import cc.mallet.cluster.evaluate.ClusteringEvaluator;
import java.util.HashSet;

public class MUCEvaluator
extends ClusteringEvaluator {
    int precisionNumerator = 0;
    int precisionDenominator = 0;
    int recallNumerator = 0;
    int recallDenominator = 0;

    @Override
    public String evaluate(Clustering truth, Clustering predicted) {
        double[] vals = this.getEvaluationScores(truth, predicted);
        return "pr=" + vals[0] + " re=" + vals[1] + " f1=" + vals[2];
    }

    @Override
    public String evaluateTotals() {
        double precision = (double)this.precisionNumerator / (double)this.precisionDenominator;
        double recall = (double)this.recallNumerator / (double)this.recallDenominator;
        return "pr=" + precision + " re=" + recall + " f1=" + 2.0 * precision * recall / (precision + recall);
    }

    @Override
    public double[] getEvaluationScores(Clustering truth, Clustering predicted) {
        int numerator = 0;
        int denominator = 0;
        int i = 0;
        while (i < predicted.getNumClusters()) {
            int[] siprime = predicted.getIndicesWithLabel(i);
            HashSet<Integer> pOfsiprime = new HashSet<Integer>();
            int j = 0;
            while (j < siprime.length) {
                pOfsiprime.add(truth.getLabel(siprime[j]));
                ++j;
            }
            numerator += siprime.length - pOfsiprime.size();
            denominator += siprime.length - 1;
            ++i;
        }
        this.precisionNumerator += numerator;
        this.precisionDenominator += denominator;
        double precision = (double)numerator / (double)denominator;
        denominator = 0;
        numerator = 0;
        int i2 = 0;
        while (i2 < truth.getNumClusters()) {
            int[] si = truth.getIndicesWithLabel(i2);
            HashSet<Integer> pOfsi = new HashSet<Integer>();
            int j = 0;
            while (j < si.length) {
                pOfsi.add(new Integer(predicted.getLabel(si[j])));
                ++j;
            }
            numerator += si.length - pOfsi.size();
            denominator += si.length - 1;
            ++i2;
        }
        this.recallNumerator += numerator;
        this.recallDenominator += denominator;
        double recall = (double)numerator / (double)denominator;
        return new double[]{precision, recall, 2.0 * precision * recall / (precision + recall)};
    }
}

