/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.fst;

import cc.mallet.fst.SegmentationEvaluator;
import cc.mallet.fst.Transducer;
import cc.mallet.fst.TransducerEvaluator;
import cc.mallet.fst.TransducerTrainer;
import cc.mallet.types.FeatureVector;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import cc.mallet.types.Sequence;
import cc.mallet.types.Token;
import cc.mallet.util.MalletLogger;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class MultiSegmentationEvaluator
extends TransducerEvaluator {
    private static Logger logger = MalletLogger.getLogger(SegmentationEvaluator.class.getName());
    Object[] segmentStartTags;
    Object[] segmentContinueTags;
    Object[] segmentStartOrContinueTags;

    public MultiSegmentationEvaluator(InstanceList[] instanceLists, String[] instanceListDescriptions, Object[] segmentStartTags, Object[] segmentContinueTags) {
        super(instanceLists, instanceListDescriptions);
        this.segmentStartTags = segmentStartTags;
        this.segmentContinueTags = segmentContinueTags;
        assert (segmentStartTags.length == segmentContinueTags.length);
    }

    public MultiSegmentationEvaluator(InstanceList instanceList1, String description1, Object[] segmentStartTags, Object[] segmentContinueTags) {
        this(new InstanceList[]{instanceList1}, new String[]{description1}, segmentStartTags, segmentContinueTags);
    }

    public MultiSegmentationEvaluator(InstanceList instanceList1, String description1, InstanceList instanceList2, String description2, Object[] segmentStartTags, Object[] segmentContinueTags) {
        this(new InstanceList[]{instanceList1, instanceList2}, new String[]{description1, description2}, segmentStartTags, segmentContinueTags);
    }

    public MultiSegmentationEvaluator(InstanceList instanceList1, String description1, InstanceList instanceList2, String description2, InstanceList instanceList3, String description3, Object[] segmentStartTags, Object[] segmentContinueTags) {
        this(new InstanceList[]{instanceList1, instanceList2, instanceList3}, new String[]{description1, description2, description3}, segmentStartTags, segmentContinueTags);
    }

    @Override
    public void evaluateInstanceList(TransducerTrainer tt, InstanceList data, String description) {
        Transducer model = tt.getTransducer();
        int allIndex = this.segmentStartTags.length;
        int[] numTrueSegments = new int[allIndex + 1];
        int[] numPredictedSegments = new int[allIndex + 1];
        int[] numCorrectSegments = new int[allIndex + 1];
        int numCorrectTokens = 0;
        int totalTokens = 0;
        int n = 0;
        while (n < numTrueSegments.length) {
            numCorrectSegments[n] = 0;
            numPredictedSegments[n] = 0;
            numTrueSegments[n] = 0;
            ++n;
        }
        int i = 0;
        while (i < data.size()) {
            Instance instance = (Instance)data.get(i);
            Sequence input = (Sequence)instance.getData();
            Sequence trueOutput = (Sequence)instance.getTarget();
            assert (input.size() == trueOutput.size());
            Sequence predOutput = model.transduce(input);
            assert (predOutput.size() == trueOutput.size());
            int j = 0;
            while (j < trueOutput.size()) {
                ++totalTokens;
                if (trueOutput.get(j).equals(predOutput.get(j))) {
                    ++numCorrectTokens;
                }
                int predStart = -1;
                int trueStart = -1;
                int n2 = 0;
                while (n2 < this.segmentStartTags.length) {
                    if (this.segmentStartTags[n2].equals(trueOutput.get(j))) {
                        int n3 = n2;
                        numTrueSegments[n3] = numTrueSegments[n3] + 1;
                        int n4 = allIndex;
                        numTrueSegments[n4] = numTrueSegments[n4] + 1;
                        trueStart = n2;
                        break;
                    }
                    ++n2;
                }
                n2 = 0;
                while (n2 < this.segmentStartTags.length) {
                    if (this.segmentStartTags[n2].equals(predOutput.get(j))) {
                        int n5 = n2;
                        numPredictedSegments[n5] = numPredictedSegments[n5] + 1;
                        int n6 = allIndex;
                        numPredictedSegments[n6] = numPredictedSegments[n6] + 1;
                        predStart = n2;
                    }
                    ++n2;
                }
                if (trueStart != -1 && trueStart == predStart) {
                    boolean trueContinue = false;
                    boolean predContinue = false;
                    int m = j + 1;
                    while (m < trueOutput.size()) {
                        trueContinue = this.segmentContinueTags[predStart].equals(trueOutput.get(m));
                        predContinue = this.segmentContinueTags[predStart].equals(predOutput.get(m));
                        if (!trueContinue || !predContinue) {
                            if (trueContinue != predContinue) break;
                            int n7 = predStart;
                            numCorrectSegments[n7] = numCorrectSegments[n7] + 1;
                            int n8 = allIndex;
                            numCorrectSegments[n8] = numCorrectSegments[n8] + 1;
                            break;
                        }
                        ++m;
                    }
                    if (m == trueOutput.size() && trueContinue == predContinue) {
                        int n9 = predStart;
                        numCorrectSegments[n9] = numCorrectSegments[n9] + 1;
                        int n10 = allIndex;
                        numCorrectSegments[n10] = numCorrectSegments[n10] + 1;
                    }
                }
                ++j;
            }
            ++i;
        }
        DecimalFormat f = new DecimalFormat("0.####");
        logger.info(String.valueOf(description) + " tokenaccuracy=" + f.format((double)numCorrectTokens / (double)totalTokens));
        int n11 = 0;
        while (n11 < numCorrectSegments.length) {
            logger.info(String.valueOf(n11 < allIndex ? this.segmentStartTags[n11].toString() : "OVERALL") + ' ');
            double precision = numPredictedSegments[n11] == 0 ? 1.0 : (double)numCorrectSegments[n11] / (double)numPredictedSegments[n11];
            double recall = numTrueSegments[n11] == 0 ? 1.0 : (double)numCorrectSegments[n11] / (double)numTrueSegments[n11];
            double f1 = recall + precision == 0.0 ? 0.0 : 2.0 * recall * precision / (recall + precision);
            logger.info(" " + description + " segments true=" + numTrueSegments[n11] + " pred=" + numPredictedSegments[n11] + " correct=" + numCorrectSegments[n11] + " misses=" + (numTrueSegments[n11] - numCorrectSegments[n11]) + " alarms=" + (numPredictedSegments[n11] - numCorrectSegments[n11]));
            logger.info(" " + description + " precision=" + f.format(precision) + " recall=" + f.format(recall) + " f1=" + f.format(f1));
            ++n11;
        }
    }

    public int numIncorrectSegments(Sequence trueOutput, Sequence predOutput) {
        int n;
        int allIndex = this.segmentStartTags.length;
        int[] numTrueSegments = new int[allIndex + 1];
        int[] numPredictedSegments = new int[allIndex + 1];
        int[] numCorrectSegments = new int[allIndex + 1];
        int numCorrectTokens = 0;
        int totalTokens = 0;
        int n2 = 0;
        while (n2 < numTrueSegments.length) {
            numCorrectSegments[n2] = 0;
            numPredictedSegments[n2] = 0;
            numTrueSegments[n2] = 0;
            ++n2;
        }
        assert (predOutput.size() == trueOutput.size());
        int j = 0;
        while (j < trueOutput.size()) {
            ++totalTokens;
            if (trueOutput.get(j).equals(predOutput.get(j))) {
                ++numCorrectTokens;
            }
            int predStart = -1;
            int trueStart = -1;
            n = 0;
            while (n < this.segmentStartTags.length) {
                if (this.segmentStartTags[n].equals(trueOutput.get(j))) {
                    int n3 = n;
                    numTrueSegments[n3] = numTrueSegments[n3] + 1;
                    int n4 = allIndex;
                    numTrueSegments[n4] = numTrueSegments[n4] + 1;
                    trueStart = n;
                    break;
                }
                ++n;
            }
            n = 0;
            while (n < this.segmentStartTags.length) {
                if (this.segmentStartTags[n].equals(predOutput.get(j))) {
                    int n5 = n;
                    numPredictedSegments[n5] = numPredictedSegments[n5] + 1;
                    int n6 = allIndex;
                    numPredictedSegments[n6] = numPredictedSegments[n6] + 1;
                    predStart = n;
                }
                ++n;
            }
            if (trueStart != -1 && trueStart == predStart) {
                boolean trueContinue = false;
                boolean predContinue = false;
                int m = j + 1;
                while (m < trueOutput.size()) {
                    trueContinue = this.segmentContinueTags[predStart].equals(trueOutput.get(m));
                    predContinue = this.segmentContinueTags[predStart].equals(predOutput.get(m));
                    if (!trueContinue || !predContinue) {
                        if (trueContinue != predContinue) break;
                        int n7 = predStart;
                        numCorrectSegments[n7] = numCorrectSegments[n7] + 1;
                        int n8 = allIndex;
                        numCorrectSegments[n8] = numCorrectSegments[n8] + 1;
                        break;
                    }
                    ++m;
                }
                if (m == trueOutput.size() && trueContinue == predContinue) {
                    int n9 = predStart;
                    numCorrectSegments[n9] = numCorrectSegments[n9] + 1;
                    int n10 = allIndex;
                    numCorrectSegments[n10] = numCorrectSegments[n10] + 1;
                }
            }
            ++j;
        }
        int wrong = 0;
        n = 0;
        while (n < numCorrectSegments.length) {
            wrong += numTrueSegments[n] - numCorrectSegments[n];
            ++n;
        }
        return wrong;
    }

    public void batchTest(InstanceList data, List<Sequence> predictedSequences, String description, PrintStream viterbiOutputStream) {
        int allIndex = this.segmentStartTags.length;
        int[] numTrueSegments = new int[allIndex + 1];
        int[] numPredictedSegments = new int[allIndex + 1];
        int[] numCorrectSegments = new int[allIndex + 1];
        ArrayList sourceTokenSequence = null;
        int numCorrectTokens = 0;
        int totalTokens = 0;
        int n = 0;
        while (n < numTrueSegments.length) {
            numCorrectSegments[n] = 0;
            numPredictedSegments[n] = 0;
            numTrueSegments[n] = 0;
            ++n;
        }
        int i = 0;
        while (i < data.size()) {
            if (viterbiOutputStream != null) {
                viterbiOutputStream.println("Viterbi path for " + description + " instance #" + i);
            }
            Instance instance = (Instance)data.get(i);
            Sequence input = (Sequence)instance.getData();
            Sequence trueOutput = (Sequence)instance.getTarget();
            assert (input.size() == trueOutput.size());
            Sequence predOutput = predictedSequences.get(i);
            if (predOutput != null) {
                assert (predOutput.size() == trueOutput.size());
                int j = 0;
                while (j < trueOutput.size()) {
                    ++totalTokens;
                    if (trueOutput.get(j).equals(predOutput.get(j))) {
                        ++numCorrectTokens;
                    }
                    int predStart = -1;
                    int trueStart = -1;
                    int n2 = 0;
                    while (n2 < this.segmentStartTags.length) {
                        if (this.segmentStartTags[n2].equals(trueOutput.get(j))) {
                            int n3 = n2;
                            numTrueSegments[n3] = numTrueSegments[n3] + 1;
                            int n4 = allIndex;
                            numTrueSegments[n4] = numTrueSegments[n4] + 1;
                            trueStart = n2;
                            break;
                        }
                        ++n2;
                    }
                    n2 = 0;
                    while (n2 < this.segmentStartTags.length) {
                        if (this.segmentStartTags[n2].equals(predOutput.get(j))) {
                            int n5 = n2;
                            numPredictedSegments[n5] = numPredictedSegments[n5] + 1;
                            int n6 = allIndex;
                            numPredictedSegments[n6] = numPredictedSegments[n6] + 1;
                            predStart = n2;
                        }
                        ++n2;
                    }
                    if (trueStart != -1 && trueStart == predStart) {
                        boolean trueContinue = false;
                        boolean predContinue = false;
                        int m = j + 1;
                        while (m < trueOutput.size()) {
                            trueContinue = this.segmentContinueTags[predStart].equals(trueOutput.get(m));
                            predContinue = this.segmentContinueTags[predStart].equals(predOutput.get(m));
                            if (!trueContinue || !predContinue) {
                                if (trueContinue != predContinue) break;
                                int n7 = predStart;
                                numCorrectSegments[n7] = numCorrectSegments[n7] + 1;
                                int n8 = allIndex;
                                numCorrectSegments[n8] = numCorrectSegments[n8] + 1;
                                break;
                            }
                            ++m;
                        }
                        if (m == trueOutput.size() && trueContinue == predContinue) {
                            int n9 = predStart;
                            numCorrectSegments[n9] = numCorrectSegments[n9] + 1;
                            int n10 = allIndex;
                            numCorrectSegments[n10] = numCorrectSegments[n10] + 1;
                        }
                    }
                    if (viterbiOutputStream != null) {
                        FeatureVector fv = (FeatureVector)input.get(j);
                        if (sourceTokenSequence != null) {
                            viterbiOutputStream.print(String.valueOf(((Token)sourceTokenSequence.get(j)).getText()) + ": ");
                        }
                        viterbiOutputStream.println(String.valueOf(trueOutput.get(j).toString()) + '/' + predOutput.get(j).toString() + "  " + fv.toString(true));
                    }
                    ++j;
                }
            }
            ++i;
        }
        DecimalFormat f = new DecimalFormat("0.####");
        logger.info(String.valueOf(description) + " tokenaccuracy=" + f.format((double)numCorrectTokens / (double)totalTokens));
        int n11 = 0;
        while (n11 < numCorrectSegments.length) {
            logger.info(String.valueOf(n11 < allIndex ? this.segmentStartTags[n11].toString() : "OVERALL") + ' ');
            double precision = numPredictedSegments[n11] == 0 ? 1.0 : (double)numCorrectSegments[n11] / (double)numPredictedSegments[n11];
            double recall = numTrueSegments[n11] == 0 ? 1.0 : (double)numCorrectSegments[n11] / (double)numTrueSegments[n11];
            double f1 = recall + precision == 0.0 ? 0.0 : 2.0 * recall * precision / (recall + precision);
            logger.info(" segments true=" + numTrueSegments[n11] + " pred=" + numPredictedSegments[n11] + " correct=" + numCorrectSegments[n11] + " misses=" + (numTrueSegments[n11] - numCorrectSegments[n11]) + " alarms=" + (numPredictedSegments[n11] - numCorrectSegments[n11]));
            logger.info(" precision=" + f.format(precision) + " recall=" + f.format(recall) + " f1=" + f.format(f1));
            ++n11;
        }
    }
}

