/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.fst.semi_supervised;

import cc.mallet.fst.CRF;
import cc.mallet.fst.CRFOptimizableByGradientValues;
import cc.mallet.fst.CRFOptimizableByLabelLikelihood;
import cc.mallet.fst.Transducer;
import cc.mallet.fst.TransducerTrainer;
import cc.mallet.fst.semi_supervised.CRFOptimizableByEntropyRegularization;
import cc.mallet.optimize.LimitedMemoryBFGS;
import cc.mallet.optimize.Optimizable;
import cc.mallet.optimize.Optimizer;
import cc.mallet.types.InstanceList;
import cc.mallet.util.MalletLogger;
import java.util.logging.Logger;

public class CRFTrainerByEntropyRegularization
extends TransducerTrainer
implements TransducerTrainer.ByOptimization {
    private static Logger logger = MalletLogger.getLogger(CRFTrainerByEntropyRegularization.class.getName());
    private static final int DEFAULT_NUM_RESETS = 1;
    private static final double DEFAULT_ER_SCALING_FACTOR = 1.0;
    private static final double DEFAULT_GAUSSIAN_PRIOR_VARIANCE = 1.0;
    private boolean converged;
    private int iteration;
    private double entRegScalingFactor;
    private double gaussianPriorVariance;
    private CRF crf;
    private LimitedMemoryBFGS bfgs;

    public CRFTrainerByEntropyRegularization(CRF crf) {
        this.crf = crf;
        this.iteration = 0;
        this.entRegScalingFactor = 1.0;
        this.gaussianPriorVariance = 1.0;
    }

    public void setGaussianPriorVariance(double variance) {
        this.gaussianPriorVariance = variance;
    }

    public void setEntropyWeight(double gamma) {
        this.entRegScalingFactor = gamma;
    }

    @Override
    public int getIteration() {
        return this.iteration;
    }

    @Override
    public Transducer getTransducer() {
        return this.crf;
    }

    @Override
    public boolean isFinishedTraining() {
        return this.converged;
    }

    @Override
    public boolean train(InstanceList trainingSet, int numIterations) {
        throw new RuntimeException("Use train(InstanceList labeled, InstanceList unlabeled, int numIterations) instead.");
    }

    public boolean train(InstanceList labeled, InstanceList unlabeled, int numIterations) {
        CRFOptimizableByLabelLikelihood likelihood;
        if (this.iteration == 0) {
            likelihood = new CRFOptimizableByLabelLikelihood(this.crf, labeled);
            likelihood.setGaussianPriorVariance(this.gaussianPriorVariance);
            this.bfgs = new LimitedMemoryBFGS(likelihood);
            logger.info("CRF about to train with " + numIterations + " iterations");
            int i = 0;
            while (i < numIterations) {
                try {
                    this.converged = this.bfgs.optimize(1);
                    ++this.iteration;
                    logger.info("CRF finished one iteration of maximizer, i=" + i);
                    this.runEvaluators();
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                    logger.info("Catching exception; saying converged.");
                    this.converged = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.info("Catching exception; saying converged.");
                    this.converged = true;
                }
                if (this.converged) {
                    logger.info("CRF training has converged, i=" + i);
                    break;
                }
                ++i;
            }
            this.iteration = 0;
        }
        likelihood = new CRFOptimizableByLabelLikelihood(this.crf, labeled);
        likelihood.setGaussianPriorVariance(this.gaussianPriorVariance);
        CRFOptimizableByEntropyRegularization regularization = new CRFOptimizableByEntropyRegularization(this.crf, unlabeled);
        regularization.setScalingFactor(this.entRegScalingFactor);
        CRFOptimizableByGradientValues regLikelihood = new CRFOptimizableByGradientValues(this.crf, new Optimizable.ByGradientValue[]{likelihood, regularization});
        this.bfgs = new LimitedMemoryBFGS(regLikelihood);
        this.converged = false;
        logger.info("CRF about to train with " + numIterations + " iterations");
        int reset = 0;
        while (reset < 2) {
            int i = 0;
            while (i < numIterations) {
                try {
                    this.converged = this.bfgs.optimize(1);
                    ++this.iteration;
                    logger.info("CRF finished one iteration of maximizer, i=" + i);
                    this.runEvaluators();
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                    logger.info("Catching exception; saying converged.");
                    this.converged = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.info("Catching exception; saying converged.");
                    this.converged = true;
                }
                if (this.converged) {
                    logger.info("CRF training has converged, i=" + i);
                    break;
                }
                ++i;
            }
            this.bfgs.reset();
            ++reset;
        }
        return this.converged;
    }

    @Override
    public Optimizer getOptimizer() {
        return this.bfgs;
    }
}

