/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.pipe;

import cc.mallet.pipe.Pipe;
import cc.mallet.types.FeatureSequence;
import cc.mallet.types.Instance;
import cc.mallet.types.Token;
import cc.mallet.types.TokenSequence;
import cc.mallet.util.PropertyList;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class PrintTokenSequenceFeatures
extends Pipe
implements Serializable {
    String prefix = null;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 0;

    public PrintTokenSequenceFeatures(String prefix) {
        this.prefix = prefix;
    }

    public PrintTokenSequenceFeatures() {
    }

    @Override
    public Instance pipe(Instance carrier) {
        TokenSequence ts = (TokenSequence)carrier.getData();
        TokenSequence targets = carrier.getTarget() instanceof TokenSequence ? (TokenSequence)carrier.getTarget() : null;
        TokenSequence source = carrier.getSource() instanceof TokenSequence ? (TokenSequence)carrier.getSource() : null;
        StringBuffer sb = new StringBuffer();
        if (this.prefix != null) {
            sb.append(this.prefix);
        }
        sb.append("name: " + carrier.getName() + "\n");
        int i = 0;
        while (i < ts.size()) {
            PropertyList pl;
            if (source != null) {
                sb.append(((Token)source.get(i)).getText());
                sb.append(' ');
            }
            if (carrier.getTarget() instanceof TokenSequence) {
                sb.append(((Token)((TokenSequence)carrier.getTarget()).get(i)).getText());
                sb.append(' ');
            }
            if (carrier.getTarget() instanceof FeatureSequence) {
                sb.append(((FeatureSequence)carrier.getTarget()).getObjectAtPosition(i).toString());
                sb.append(' ');
            }
            if ((pl = ((Token)ts.get(i)).getFeatures()) != null) {
                PropertyList.Iterator iter = pl.iterator();
                while (iter.hasNext()) {
                    iter.next();
                    double v = iter.getNumericValue();
                    if (v == 1.0) {
                        sb.append(iter.getKey());
                    } else {
                        sb.append(String.valueOf(iter.getKey()) + '=' + v);
                    }
                    sb.append(' ');
                }
            }
            sb.append('\n');
            ++i;
        }
        System.out.print(sb.toString());
        return carrier;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(0);
        out.writeObject(this.prefix);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        this.prefix = (String)in.readObject();
    }
}

