/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.pipe;

import cc.mallet.pipe.Pipe;
import cc.mallet.types.Instance;
import cc.mallet.types.Token;
import cc.mallet.types.TokenSequence;
import cc.mallet.util.CharSequenceLexer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class TokenSequenceRemoveNonAlpha
extends Pipe {
    boolean markDeletions = false;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 0;

    public TokenSequenceRemoveNonAlpha(boolean markDeletions) {
        this.markDeletions = markDeletions;
    }

    public TokenSequenceRemoveNonAlpha() {
        this(false);
    }

    @Override
    public Instance pipe(Instance carrier) {
        TokenSequence ts = (TokenSequence)carrier.getData();
        TokenSequence ret = new TokenSequence();
        Token prevToken = null;
        int i = 0;
        while (i < ts.size()) {
            Token t = (Token)ts.get(i);
            String s = t.getText();
            if (CharSequenceLexer.LEX_ALPHA.matcher(s).matches()) {
                ret.add(t);
                prevToken = t;
            } else if (this.markDeletions && prevToken != null) {
                prevToken.setProperty("NextTokenDeleted", t.getText());
            }
            ++i;
        }
        carrier.setData(ret);
        return carrier;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(0);
        out.writeBoolean(this.markDeletions);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        this.markDeletions = in.readBoolean();
    }
}

