/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.pipe.iterator;

import cc.mallet.pipe.iterator.FileIterator;
import cc.mallet.types.Instance;
import cc.mallet.util.Strings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileListIterator
implements Iterator<Instance> {
    FileFilter fileFilter;
    ArrayList fileArray;
    Iterator subIterator;
    Pattern targetPattern;
    int commonPrefixIndex;
    public static final Pattern STARTING_DIRECTORIES = Pattern.compile("_STARTING_DIRECTORIES_");
    public static final Pattern FIRST_DIRECTORY = Pattern.compile("/?([^/]*)/.+");
    public static final Pattern LAST_DIRECTORY = Pattern.compile(".*/([^/]+)/[^/]+");
    public static final Pattern ALL_DIRECTORIES = Pattern.compile("^(.*)/[^/]+");

    public FileListIterator(File[] files, FileFilter fileFilter, Pattern targetPattern, boolean removeCommonPrefix) {
        this.fileFilter = fileFilter;
        this.fileArray = new ArrayList();
        this.targetPattern = targetPattern;
        this.fillFileArrayAssignCommonPrefixIndexAndSubIterator(files, removeCommonPrefix);
    }

    public FileListIterator(String[] filenames, FileFilter fileFilter, Pattern targetPattern, boolean removeCommonPrefix) {
        this(FileIterator.stringArray2FileArray(filenames), fileFilter, targetPattern, removeCommonPrefix);
    }

    public FileListIterator(File filelist, FileFilter fileFilter, Pattern targetPattern, boolean removeCommonPrefix) throws FileNotFoundException, IOException {
        this.fileFilter = fileFilter;
        this.fileArray = new ArrayList();
        this.targetPattern = targetPattern;
        List filenames = FileListIterator.readFileNames(filelist);
        File[] fa = FileListIterator.stringList2FileArray(filenames, null);
        this.fillFileArrayAssignCommonPrefixIndexAndSubIterator(fa, removeCommonPrefix);
    }

    public FileListIterator(File filelist, File baseDirectory, FileFilter fileFilter, Pattern targetPattern, boolean removeCommonPrefix) throws FileNotFoundException, IOException {
        this.fileFilter = fileFilter;
        this.fileArray = new ArrayList();
        this.targetPattern = targetPattern;
        List filenames = FileListIterator.readFileNames(filelist);
        File[] fa = FileListIterator.stringList2FileArray(filenames, baseDirectory);
        this.fillFileArrayAssignCommonPrefixIndexAndSubIterator(fa, removeCommonPrefix);
    }

    private static File[] stringList2FileArray(List filenames, File baseDir) {
        File[] fa = new File[filenames.size()];
        int i = 0;
        while (i < filenames.size()) {
            fa[i] = baseDir != null ? new File(baseDir, (String)filenames.get(i)) : new File((String)filenames.get(i));
            ++i;
        }
        return fa;
    }

    private static List readFileNames(File filelist) throws IOException {
        ArrayList<String> filenames = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new FileReader(filelist));
        String filename = reader.readLine();
        while (filename != null && filename.trim().length() > 0) {
            filenames.add(filename.trim());
            filename = reader.readLine();
        }
        reader.close();
        return filenames;
    }

    public FileListIterator(String filelistName, FileFilter fileFilter, Pattern targetPattern, boolean removeCommonPrefix) throws FileNotFoundException, IOException {
        this(new File(filelistName), fileFilter, targetPattern, removeCommonPrefix);
    }

    public FileListIterator(String filelistName, Pattern targetPattern) throws FileNotFoundException, IOException {
        this(new File(filelistName), null, targetPattern, true);
    }

    @Override
    public Instance next() {
        Matcher m;
        File nextFile = (File)this.subIterator.next();
        String path = nextFile.getParent();
        String targetName = null;
        if (this.targetPattern == STARTING_DIRECTORIES) {
            targetName = path.substring(this.commonPrefixIndex);
        } else if (this.targetPattern != null && (m = this.targetPattern.matcher(path)).find()) {
            targetName = m.group(1);
        }
        return new Instance(nextFile, targetName, nextFile.toURI(), null);
    }

    public File nextFile() {
        return (File)this.subIterator.next();
    }

    @Override
    public boolean hasNext() {
        return this.subIterator.hasNext();
    }

    @Override
    public void remove() {
        throw new IllegalStateException("This Iterator<Instance> does not support remove().");
    }

    public ArrayList getFileArray() {
        return this.fileArray;
    }

    private void fillFileArrayAssignCommonPrefixIndexAndSubIterator(File[] files, boolean removeCommonPrefix) {
        ArrayList<String> filenames = new ArrayList<String>();
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                throw new IllegalArgumentException(files[i] + " is not a file.");
            }
            if (!files[i].exists()) {
                throw new IllegalArgumentException(files[i] + " does not exist.");
            }
            if (this.fileFilter == null || this.fileFilter.accept(files[i])) {
                this.fileArray.add(files[i]);
                if (removeCommonPrefix) {
                    filenames.add(files[i].getPath());
                }
            }
            ++i;
        }
        this.subIterator = this.fileArray.iterator();
        if (removeCommonPrefix) {
            String[] fn = new String[filenames.size()];
            int i2 = 0;
            while (i2 < fn.length) {
                fn[i2] = (String)filenames.get(i2);
                ++i2;
            }
            this.commonPrefixIndex = Strings.commonPrefixIndex(fn);
        } else {
            this.commonPrefixIndex = 0;
        }
    }
}

