/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.share.upenn.ner;

import cc.mallet.pipe.Pipe;
import cc.mallet.types.Instance;
import cc.mallet.types.Token;
import cc.mallet.types.TokenSequence;
import java.io.Serializable;
import java.util.regex.Pattern;

public class LongRegexMatches
extends Pipe
implements Serializable {
    String name;
    Pattern regex;
    int min;
    int max;

    public LongRegexMatches(String featureName, Pattern regex, int min, int max) {
        this.name = featureName;
        this.regex = regex;
        this.min = min;
        this.max = max;
    }

    @Override
    public Instance pipe(Instance carrier) {
        TokenSequence ts = (TokenSequence)carrier.getData();
        boolean[] marked = new boolean[ts.size()];
        int i = 0;
        while (i < ts.size()) {
            StringBuffer sb = new StringBuffer();
            int length = 1;
            while (length <= this.max) {
                int loc = i - length + 1;
                if (loc < 0) break;
                sb.insert(0, ((Token)ts.get(loc)).getText());
                if (length >= this.min && this.regex.matcher(sb.toString()).matches()) {
                    int j = 0;
                    while (j < length) {
                        marked[loc + j] = true;
                        ++j;
                    }
                }
                ++length;
            }
            ++i;
        }
        i = 0;
        while (i < ts.size()) {
            if (marked[i]) {
                ((Token)ts.get(i)).setFeatureValue(this.name, 1.0);
            }
            ++i;
        }
        return carrier;
    }
}

