/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.topics;

import cc.mallet.topics.ParallelTopicModel;
import cc.mallet.topics.TopicAssignment;
import cc.mallet.topics.TopicModelDiagnostics;
import cc.mallet.types.FeatureSequence;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import gnu.trove.TIntIntHashMap;
import java.io.File;

public class RTopicModel
extends ParallelTopicModel {
    public InstanceList instances = null;

    public RTopicModel(double numTopics, double alpha, double beta) {
        super((int)Math.floor(numTopics), alpha, beta);
    }

    public void loadDocuments(String filename) {
        this.instances = InstanceList.load(new File(filename));
        this.addInstances(this.instances);
    }

    public void loadDocuments(InstanceList instances) {
        this.instances = instances;
        this.addInstances(instances);
    }

    public static void addInstance(InstanceList instances, String id, String text) {
        instances.addThruPipe(new Instance(text, null, id, null));
    }

    public static void addInstances(InstanceList instances, String[] ids, String[] texts) {
        int i = 0;
        while (i < ids.length) {
            instances.addThruPipe(new Instance(texts[i], null, ids[i], null));
            ++i;
        }
    }

    public void setAlphaOptimization(double frequency, double burnin) {
        this.setBurninPeriod((int)Math.floor(burnin));
        this.setOptimizeInterval((int)Math.floor(frequency));
    }

    public void train(double numIterations) {
        try {
            this.setNumIterations((int)Math.floor(numIterations));
            this.estimate();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void maximize(double numIterations) {
        this.maximize((int)Math.floor(numIterations));
    }

    public double[] getAlpha() {
        return this.alpha;
    }

    public String[] getVocabulary() {
        String[] vocab = new String[this.alphabet.size()];
        int type = 0;
        while (type < this.numTypes) {
            vocab[type] = (String)this.alphabet.lookupObject(type);
            ++type;
        }
        return vocab;
    }

    public String[] getDocumentNames() {
        String[] docNames = new String[this.data.size()];
        int doc = 0;
        while (doc < docNames.length) {
            docNames[doc] = (String)((TopicAssignment)this.data.get((int)doc)).instance.getName();
            ++doc;
        }
        return docNames;
    }

    public double[][] getWordFrequencies() {
        if (this.instances == null) {
            throw new IllegalStateException("You must load instances before you can count features");
        }
        double[][] result = new double[this.numTypes][2];
        TIntIntHashMap docCounts = new TIntIntHashMap();
        for (Instance instance : this.instances) {
            FeatureSequence features = (FeatureSequence)instance.getData();
            int i = 0;
            while (i < features.getLength()) {
                docCounts.adjustOrPutValue(features.getIndexAtPosition(i), 1, 1);
                ++i;
            }
            int[] keys = docCounts.keys();
            int i2 = 0;
            while (i2 < keys.length) {
                int feature = keys[i2];
                double[] dArray = result[feature];
                dArray[0] = dArray[0] + (double)docCounts.get(feature);
                double[] dArray2 = result[feature];
                dArray2[1] = dArray2[1] + 1.0;
                ++i2;
            }
            docCounts = new TIntIntHashMap();
        }
        return result;
    }

    public TopicModelDiagnostics getDiagnostics(double numWords) {
        return new TopicModelDiagnostics(this, (int)Math.floor(numWords));
    }

    public void writeState(String filename) {
        try {
            this.printState(new File(filename));
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }
}

