/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.types;

import cc.mallet.types.Alphabet;
import cc.mallet.types.AlphabetCarrying;
import cc.mallet.types.FeatureSequence;
import cc.mallet.types.Label;
import cc.mallet.types.LabelAlphabet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class LabelSequence
extends FeatureSequence
implements AlphabetCarrying,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 0;

    public LabelSequence(LabelAlphabet dict, int[] features) {
        super((Alphabet)dict, features);
    }

    public LabelSequence(LabelAlphabet dict, int capacity) {
        super((Alphabet)dict, capacity);
    }

    private static int[] getFeaturesFromLabels(Label[] labels) {
        int[] features = new int[labels.length];
        int i = 0;
        while (i < labels.length) {
            features[i] = labels[i].getIndex();
            ++i;
        }
        return features;
    }

    public LabelSequence(Label[] labels) {
        super((Alphabet)labels[0].getLabelAlphabet(), LabelSequence.getFeaturesFromLabels(labels));
    }

    public LabelSequence(Alphabet dict) {
        super(dict);
    }

    public LabelAlphabet getLabelAlphabet() {
        return (LabelAlphabet)this.dictionary;
    }

    public Label getLabelAtPosition(int pos) {
        return ((LabelAlphabet)this.dictionary).lookupLabel(this.features[pos]);
    }

    public Iterator iterator() {
        return new Iterator();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(0);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
    }

    public class Iterator
    implements java.util.Iterator {
        int pos = 0;

        public Object next() {
            return LabelSequence.this.getLabelAtPosition(this.pos++);
        }

        public int getIndex() {
            return this.pos;
        }

        @Override
        public boolean hasNext() {
            return this.pos < LabelSequence.this.features.length;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

