/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.types;

import cc.mallet.types.ConstantMatrix;
import cc.mallet.types.DenseMatrix;

public class Matrixn
extends DenseMatrix
implements Cloneable {
    int numDimensions;
    int[] sizes;
    private static final long serialVersionUID = 7963668115823191655L;

    public Matrixn(double[] vals) {
        this.numDimensions = 1;
        this.sizes = new int[1];
        this.sizes[0] = vals.length;
        this.values = (double[])vals.clone();
    }

    public Matrixn(int[] szs) {
        this.numDimensions = szs.length;
        this.sizes = szs;
        int total = 1;
        int j = 0;
        while (j < this.numDimensions) {
            total *= this.sizes[j];
            ++j;
        }
        this.values = new double[total];
    }

    public Matrixn(int[] szs, double[] vals) {
        this.numDimensions = szs.length;
        this.sizes = (int[])szs.clone();
        this.values = (double[])vals.clone();
    }

    @Override
    public int getNumDimensions() {
        return this.numDimensions;
    }

    @Override
    public int getDimensions(int[] szs) {
        int i = 0;
        while (i < this.numDimensions) {
            szs[i] = this.sizes[i];
            ++i;
        }
        return this.numDimensions;
    }

    @Override
    public double value(int[] indices) {
        return this.values[this.singleIndex(indices)];
    }

    @Override
    public void setValue(int[] indices, double value) {
        this.values[this.singleIndex((int[])indices)] = value;
    }

    @Override
    public ConstantMatrix cloneMatrix() {
        return new Matrixn(this.sizes, this.values);
    }

    public Object clone() {
        return this.cloneMatrix();
    }

    @Override
    public int singleIndex(int[] indices) {
        return Matrixn.singleIndex(this.sizes, indices);
    }

    public static int singleIndex(int[] szs, int[] indices) {
        int idx = 0;
        int dim = 0;
        while (dim < indices.length) {
            idx = idx * szs[dim] + indices[dim];
            ++dim;
        }
        return idx;
    }

    @Override
    public void singleToIndices(int single, int[] indices) {
        int size = 1;
        int i = 0;
        while (i < this.numDimensions) {
            size *= this.sizes[i];
            ++i;
        }
        int dim = 0;
        while (dim < this.numDimensions) {
            indices[dim] = single / (size /= this.sizes[dim]);
            single %= size;
            ++dim;
        }
    }

    public static void singleToIndices(int single, int[] indices, int[] szs) {
        int numd = indices.length;
        assert (numd == szs.length);
        int size = 1;
        int i = 0;
        while (i < numd) {
            size *= szs[i];
            ++i;
        }
        int dim = 0;
        while (dim < numd) {
            indices[dim] = single / (size /= szs[dim]);
            single %= size;
            ++dim;
        }
    }

    public boolean equals(Object o) {
        if (o instanceof Matrixn) {
            Matrixn m2 = (Matrixn)o;
            return this.numDimensions == m2.numDimensions && this.sizes.equals(m2.sizes) && this.values.equals(m2.values);
        }
        return false;
    }

    public double[] toArray() {
        return this.values;
    }

    public static void main(String[] args) {
        double[] m1 = new double[]{1.0, 2.0, 3.0, 4.0};
        int[] idx1 = new int[1];
        Matrixn a = new Matrixn(m1);
        System.out.println("Checking 1-D case");
        a.singleToIndices(3, idx1);
        System.out.println(idx1[0]);
        System.out.println(a.singleIndex(idx1));
        System.out.println("Checking 2-D case");
        int[] sizes = new int[]{2, 3};
        m1 = new double[6];
        int i = 0;
        while (i < 6) {
            m1[i] = 2.0 * (double)i;
            ++i;
        }
        a = new Matrixn(sizes, m1);
        idx1 = new int[2];
        a.singleToIndices(5, idx1);
        System.out.println("5 => (" + idx1[0] + ", " + idx1[1] + ") => " + a.singleIndex(idx1));
        System.out.println(a.value(idx1));
        System.out.println("Checking 3-D case");
        sizes = new int[]{2, 3, 4};
        idx1 = new int[3];
        m1 = new double[24];
        i = 0;
        while (i < 24) {
            m1[i] = 2.0 * (double)i;
            ++i;
        }
        a = new Matrixn(sizes, m1);
        a.singleToIndices(21, idx1);
        System.out.println("21 => (" + idx1[0] + " " + idx1[1] + " " + idx1[2] + ") =>" + a.singleIndex(idx1));
        System.out.println(a.value(idx1));
    }
}

