/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.classify;

import cc.mallet.classify.Classification;
import cc.mallet.classify.Classifier;
import cc.mallet.pipe.Pipe;
import cc.mallet.types.FeatureVector;
import cc.mallet.types.Instance;
import cc.mallet.types.LabelVector;

public class Winnow
extends Classifier {
    double[][] weights;
    double theta;

    public Winnow(Pipe dataPipe, double[][] newWeights, double theta, int idim, int jdim) {
        super(dataPipe);
        this.theta = theta;
        this.weights = new double[idim][jdim];
        int i = 0;
        while (i < idim) {
            int j = 0;
            while (j < jdim) {
                this.weights[i][j] = newWeights[i][j];
                ++j;
            }
            ++i;
        }
    }

    @Override
    public Classification classify(Instance instance) {
        int numClasses = this.getLabelAlphabet().size();
        double[] scores = new double[numClasses];
        FeatureVector fv = (FeatureVector)instance.getData();
        assert (this.instancePipe == null || fv.getAlphabet() == this.instancePipe.getDataAlphabet());
        int fvisize = fv.numLocations();
        int fvi = 0;
        while (fvi < fvisize) {
            int fi = fv.indexAtLocation(fvi);
            int ci = 0;
            while (ci < numClasses) {
                int n = ci;
                scores[n] = scores[n] + this.weights[ci][fi];
                ++ci;
            }
            ++fvi;
        }
        return new Classification(instance, this, new LabelVector(this.getLabelAlphabet(), scores));
    }
}

