/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.classify.constraints.ge;

import cc.mallet.classify.constraints.ge.MaxEntFLGEConstraints;
import cc.mallet.types.MatrixOps;
import cc.mallet.util.Maths;

public class MaxEntKLFLGEConstraints
extends MaxEntFLGEConstraints {
    public MaxEntKLFLGEConstraints(int numFeatures, int numLabels, boolean useValues) {
        super(numFeatures, numLabels, useValues);
    }

    @Override
    public double getValue() {
        double value = 0.0;
        int[] nArray = this.constraints.keys();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int fi = nArray[n2];
            MaxEntFLGEConstraints.MaxEntFLGEConstraint constraint = (MaxEntFLGEConstraints.MaxEntFLGEConstraint)this.constraints.get(fi);
            if (constraint.count > 0.0) {
                double constraintValue = 0.0;
                int labelIndex = 0;
                while (labelIndex < this.numLabels) {
                    if (constraint.target[labelIndex] > 0.0) {
                        if (constraint.expectation[labelIndex] == 0.0) {
                            return Double.NEGATIVE_INFINITY;
                        }
                        constraintValue += constraint.target[labelIndex] * (Math.log(constraint.expectation[labelIndex] / constraint.count) - Math.log(constraint.target[labelIndex]));
                    }
                    ++labelIndex;
                }
                assert (!Double.isNaN(constraintValue) && !Double.isInfinite(constraintValue));
                value += constraintValue * constraint.weight;
            }
            ++n2;
        }
        return value;
    }

    @Override
    public void addConstraint(int fi, double[] ex, double weight) {
        assert (Maths.almostEquals(MatrixOps.sum(ex), 1.0));
        this.constraints.put(fi, new MaxEntKLFLGEConstraint(ex, weight));
    }

    protected class MaxEntKLFLGEConstraint
    extends MaxEntFLGEConstraints.MaxEntFLGEConstraint {
        public MaxEntKLFLGEConstraint(double[] target, double weight) {
            super(target, weight);
        }

        @Override
        public double getValue(int li) {
            assert (this.count != 0.0);
            if (this.target[li] == 0.0 && this.expectation[li] == 0.0) {
                return 0.0;
            }
            return this.weight * (this.target[li] / this.expectation[li]);
        }
    }
}

